/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.types.DataTypeFamily;

@Public
public enum DataTypeRoot {
    CHAR(DataTypeFamily.PREDEFINED, DataTypeFamily.CHARACTER_STRING),
    VARCHAR(DataTypeFamily.PREDEFINED, DataTypeFamily.CHARACTER_STRING),
    BOOLEAN(DataTypeFamily.PREDEFINED, new DataTypeFamily[0]),
    BINARY(DataTypeFamily.PREDEFINED, DataTypeFamily.BINARY_STRING),
    VARBINARY(DataTypeFamily.PREDEFINED, DataTypeFamily.BINARY_STRING),
    DECIMAL(DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.EXACT_NUMERIC),
    TINYINT(DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.INTEGER_NUMERIC, DataTypeFamily.EXACT_NUMERIC),
    SMALLINT(DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.INTEGER_NUMERIC, DataTypeFamily.EXACT_NUMERIC),
    INTEGER(DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.INTEGER_NUMERIC, DataTypeFamily.EXACT_NUMERIC),
    BIGINT(DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.INTEGER_NUMERIC, DataTypeFamily.EXACT_NUMERIC),
    FLOAT(DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.APPROXIMATE_NUMERIC),
    DOUBLE(DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.APPROXIMATE_NUMERIC),
    DATE(DataTypeFamily.PREDEFINED, DataTypeFamily.DATETIME),
    TIME_WITHOUT_TIME_ZONE(DataTypeFamily.PREDEFINED, DataTypeFamily.DATETIME, DataTypeFamily.TIME),
    TIMESTAMP_WITHOUT_TIME_ZONE(DataTypeFamily.PREDEFINED, DataTypeFamily.DATETIME, DataTypeFamily.TIMESTAMP),
    TIMESTAMP_WITH_LOCAL_TIME_ZONE(DataTypeFamily.PREDEFINED, DataTypeFamily.DATETIME, DataTypeFamily.TIMESTAMP, DataTypeFamily.EXTENSION),
    ARRAY(DataTypeFamily.CONSTRUCTED, DataTypeFamily.COLLECTION),
    MULTISET(DataTypeFamily.CONSTRUCTED, DataTypeFamily.COLLECTION),
    MAP(DataTypeFamily.CONSTRUCTED, DataTypeFamily.EXTENSION),
    ROW(DataTypeFamily.CONSTRUCTED, new DataTypeFamily[0]);

    private final Set<DataTypeFamily> families;

    private DataTypeRoot(DataTypeFamily firstFamily, DataTypeFamily ... otherFamilies) {
        this.families = Collections.unmodifiableSet(EnumSet.of(firstFamily, otherFamilies));
    }

    public Set<DataTypeFamily> getFamilies() {
        return this.families;
    }
}

