/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFromTimestampStartingScanner
extends AbstractStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(StaticFromTimestampStartingScanner.class);
    private final long startupMillis;

    public StaticFromTimestampStartingScanner(SnapshotManager snapshotManager, long startupMillis) {
        super(snapshotManager);
        this.startupMillis = startupMillis;
        Snapshot snapshot = StaticFromTimestampStartingScanner.timeTravelToTimestamp(snapshotManager, startupMillis);
        if (snapshot != null) {
            this.startingSnapshotId = snapshot.id();
        }
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader snapshotReader) {
        if (this.startingSnapshotId == null) {
            LOG.debug("There is currently no snapshot earlier than or equal to timestamp[{}]", (Object)this.startupMillis);
            return new StartingScanner.NoSnapshot();
        }
        return StartingScanner.fromPlan(snapshotReader.withMode(ScanMode.ALL).withSnapshot(this.startingSnapshotId).read());
    }

    @Nullable
    public static Snapshot timeTravelToTimestamp(SnapshotManager snapshotManager, long timestamp) {
        return snapshotManager.earlierOrEqualTimeMills(timestamp);
    }
}

