/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup;

public enum LookupStrategy {
    NO_LOOKUP(false, false),
    CHANGELOG_ONLY(true, false),
    DELETION_VECTOR_ONLY(false, true),
    CHANGELOG_AND_DELETION_VECTOR(true, true);

    public final boolean needLookup;
    public final boolean produceChangelog;
    public final boolean deletionVector;

    private LookupStrategy(boolean produceChangelog, boolean deletionVector) {
        this.produceChangelog = produceChangelog;
        this.deletionVector = deletionVector;
        this.needLookup = produceChangelog || deletionVector;
    }

    public static LookupStrategy from(boolean produceChangelog, boolean deletionVector) {
        for (LookupStrategy strategy : LookupStrategy.values()) {
            if (strategy.produceChangelog != produceChangelog || strategy.deletionVector != deletionVector) continue;
            return strategy;
        }
        throw new IllegalArgumentException("Invalid combination of produceChangelog : " + produceChangelog + " and deletionVector : " + deletionVector);
    }
}

