/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsIndexFile;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.HashIndexFile;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.IndexManifestFile;
import org.apache.paimon.utils.IntIterator;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.SnapshotManager;

public class IndexFileHandler {
    private final SnapshotManager snapshotManager;
    private final PathFactory pathFactory;
    private final IndexManifestFile indexManifestFile;
    private final HashIndexFile hashIndex;
    private final DeletionVectorsIndexFile deletionVectorsIndex;

    public IndexFileHandler(SnapshotManager snapshotManager, PathFactory pathFactory, IndexManifestFile indexManifestFile, HashIndexFile hashIndex, DeletionVectorsIndexFile deletionVectorsIndex) {
        this.snapshotManager = snapshotManager;
        this.pathFactory = pathFactory;
        this.indexManifestFile = indexManifestFile;
        this.hashIndex = hashIndex;
        this.deletionVectorsIndex = deletionVectorsIndex;
    }

    public Optional<IndexFileMeta> scan(long snapshotId, String indexType, BinaryRow partition, int bucket) {
        List<IndexManifestEntry> entries = this.scan(snapshotId, indexType, partition);
        ArrayList<IndexManifestEntry> result = new ArrayList<IndexManifestEntry>();
        for (IndexManifestEntry file : entries) {
            if (file.bucket() != bucket) continue;
            result.add(file);
        }
        if (result.size() > 1) {
            throw new IllegalArgumentException("Find multiple index files for one bucket: " + result);
        }
        return result.isEmpty() ? Optional.empty() : Optional.of(((IndexManifestEntry)result.get(0)).indexFile());
    }

    public List<IndexManifestEntry> scan(String indexType, BinaryRow partition) {
        Long snapshot = this.snapshotManager.latestSnapshotId();
        if (snapshot == null) {
            return Collections.emptyList();
        }
        return this.scan(snapshot, indexType, partition);
    }

    public List<IndexManifestEntry> scan(long snapshotId, String indexType, BinaryRow partition) {
        Snapshot snapshot = this.snapshotManager.snapshot(snapshotId);
        String indexManifest = snapshot.indexManifest();
        if (indexManifest == null) {
            return Collections.emptyList();
        }
        List allFiles = this.indexManifestFile.read(indexManifest);
        ArrayList<IndexManifestEntry> result = new ArrayList<IndexManifestEntry>();
        for (IndexManifestEntry file : allFiles) {
            if (!file.indexFile().indexType().equals(indexType) || !file.partition().equals(partition)) continue;
            result.add(file);
        }
        return result;
    }

    public Path filePath(IndexFileMeta file) {
        return this.pathFactory.toPath(file.fileName());
    }

    public List<Integer> readHashIndexList(IndexFileMeta file) {
        return IntIterator.toIntList(this.readHashIndex(file));
    }

    public IntIterator readHashIndex(IndexFileMeta file) {
        if (!file.indexType().equals("HASH")) {
            throw new IllegalArgumentException("Input file is not hash index: " + file.indexType());
        }
        try {
            return this.hashIndex.read(file.fileName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public IndexFileMeta writeHashIndex(int[] ints) {
        return this.writeHashIndex(ints.length, IntIterator.create(ints));
    }

    public IndexFileMeta writeHashIndex(int size, IntIterator iterator) {
        String file;
        try {
            file = this.hashIndex.write(iterator);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new IndexFileMeta("HASH", file, this.hashIndex.fileSize(file), size);
    }

    public boolean existsManifest(String indexManifest) {
        return this.indexManifestFile.exists(indexManifest);
    }

    public List<IndexManifestEntry> readManifest(String indexManifest) {
        return this.indexManifestFile.read(indexManifest);
    }

    public List<IndexManifestEntry> readManifestWithIOException(String indexManifest) throws IOException {
        return this.indexManifestFile.readWithIOException(indexManifest);
    }

    public boolean existsIndexFile(IndexManifestEntry file) {
        return this.hashIndex.exists(file.indexFile().fileName());
    }

    public void deleteIndexFile(IndexManifestEntry file) {
        this.hashIndex.delete(file.indexFile().fileName());
    }

    public void deleteManifest(String indexManifest) {
        this.indexManifestFile.delete(indexManifest);
    }

    public Map<String, DeletionVector> readAllDeletionVectors(IndexFileMeta fileMeta) {
        if (!fileMeta.indexType().equals("DELETION_VECTORS")) {
            throw new IllegalArgumentException("Input file is not deletion vectors index " + fileMeta.indexType());
        }
        LinkedHashMap<String, Pair<Integer, Integer>> deleteIndexRange = fileMeta.deletionVectorsRanges();
        if (deleteIndexRange == null || deleteIndexRange.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.deletionVectorsIndex.readAllDeletionVectors(fileMeta.fileName(), deleteIndexRange);
    }

    public Optional<DeletionVector> readDeletionVector(IndexFileMeta fileMeta, String fileName) {
        if (!fileMeta.indexType().equals("DELETION_VECTORS")) {
            throw new IllegalArgumentException("Input file is not deletion vectors index " + fileMeta.indexType());
        }
        LinkedHashMap<String, Pair<Integer, Integer>> deleteIndexRange = fileMeta.deletionVectorsRanges();
        if (deleteIndexRange == null || !deleteIndexRange.containsKey(fileName)) {
            return Optional.empty();
        }
        return Optional.of(this.deletionVectorsIndex.readDeletionVector(fileMeta.fileName(), (Pair)deleteIndexRange.get(fileName)));
    }

    public IndexFileMeta writeDeletionVectorsIndex(Map<String, DeletionVector> deletionVectors) {
        Pair<String, LinkedHashMap<String, Pair<Integer, Integer>>> pair = this.deletionVectorsIndex.write(deletionVectors);
        return new IndexFileMeta("DELETION_VECTORS", pair.getLeft(), this.deletionVectorsIndex.fileSize(pair.getLeft()), deletionVectors.size(), pair.getRight());
    }
}

