/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.apache.paimon.fs.SeekableInputStream;

public class ByteArraySeekableStream
extends SeekableInputStream {
    private final ByteArrayStream byteArrayStream;

    public ByteArraySeekableStream(byte[] buf) {
        this.byteArrayStream = new ByteArrayStream(buf);
    }

    @Override
    public void seek(long desired) throws IOException {
        this.byteArrayStream.seek((int)desired);
    }

    @Override
    public long getPos() throws IOException {
        return this.byteArrayStream.getPos();
    }

    @Override
    public int read() throws IOException {
        return this.byteArrayStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.byteArrayStream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.byteArrayStream.read(b);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.byteArrayStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.byteArrayStream.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.byteArrayStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.byteArrayStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.byteArrayStream.markSupported();
    }

    @Override
    public void close() throws IOException {
        this.byteArrayStream.close();
    }

    private static class ByteArrayStream
    extends ByteArrayInputStream {
        public ByteArrayStream(byte[] buf) {
            super(buf);
        }

        public void seek(int position) throws IOException {
            if (position >= this.count) {
                throw new EOFException("Can't seek position: " + position + ", length is " + this.count);
            }
            this.pos = position;
        }

        public long getPos() {
            return this.pos;
        }
    }
}

