/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.bloomfilter;

import org.apache.paimon.fileindex.FileIndexReader;
import org.apache.paimon.fileindex.FileIndexWriter;
import org.apache.paimon.fileindex.FileIndexer;
import org.apache.paimon.fileindex.bloomfilter.FastHash;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.BloomFilter64;

public class BloomFilterFileIndex
implements FileIndexer {
    public static final String BLOOM_FILTER = "bloom-filter";
    private static final int DEFAULT_ITEMS = 1000000;
    private static final double DEFAULT_FPP = 0.1;
    private static final String ITEMS = "items";
    private static final String FPP = "fpp";
    private final DataType dataType;
    private final int items;
    private final double fpp;

    public BloomFilterFileIndex(DataType dataType, Options options) {
        this.dataType = dataType;
        this.items = options.getInteger(ITEMS, 1000000);
        this.fpp = options.getDouble(FPP, 0.1);
    }

    public String name() {
        return BLOOM_FILTER;
    }

    @Override
    public FileIndexWriter createWriter() {
        return new Writer(this.dataType, this.items, this.fpp);
    }

    @Override
    public FileIndexReader createReader(byte[] serializedBytes) {
        return new Reader(this.dataType, serializedBytes);
    }

    private static class Reader
    extends FileIndexReader {
        private final BloomFilter64 filter;
        private final FastHash hashFunction;

        public Reader(DataType type, byte[] serializedBytes) {
            int numHashFunctions = (serializedBytes[0] << 24) + (serializedBytes[1] << 16) + (serializedBytes[2] << 8) + serializedBytes[3];
            BloomFilter64.BitSet bitSet = new BloomFilter64.BitSet(serializedBytes, 4);
            this.filter = new BloomFilter64(numHashFunctions, bitSet);
            this.hashFunction = FastHash.getHashFunction(type);
        }

        @Override
        public Boolean visitEqual(FieldRef fieldRef, Object key) {
            return key == null || this.filter.testHash(this.hashFunction.hash(key));
        }
    }

    private static class Writer
    extends FileIndexWriter {
        private final BloomFilter64 filter;
        private final FastHash hashFunction;

        public Writer(DataType type, int items, double fpp) {
            this.filter = new BloomFilter64((long)items, fpp);
            this.hashFunction = FastHash.getHashFunction(type);
        }

        @Override
        public void write(Object key) {
            this.filter.addHash(this.hashFunction.hash(key));
        }

        @Override
        public byte[] serializedBytes() {
            int numHashFunctions = this.filter.getNumHashFunctions();
            byte[] serialized = new byte[this.filter.getBitSet().bitSize() / 8 + 4];
            serialized[0] = (byte)(numHashFunctions >>> 24 & 0xFF);
            serialized[1] = (byte)(numHashFunctions >>> 16 & 0xFF);
            serialized[2] = (byte)(numHashFunctions >>> 8 & 0xFF);
            serialized[3] = (byte)(numHashFunctions & 0xFF);
            this.filter.getBitSet().toByteArray(serialized, 4, serialized.length - 4);
            return serialized;
        }
    }
}

