/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFile;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileIndex;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyService;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerSpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.NoOpMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierProducerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk.DiskTierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk.DiskTierProducerAgent;

public class DiskTierFactory
implements TierFactory {
    private final int numBytesPerSegment;
    private final int bufferSizeBytes;
    private final float minReservedDiskSpaceFraction;
    private final int regionGroupSizeInBytes;
    private final int maxCachedBytesBeforeFlush;
    private final long numRetainedInMemoryRegionsMax;

    public DiskTierFactory(int numBytesPerSegment, int bufferSizeBytes, float minReservedDiskSpaceFraction, int regionGroupSizeInBytes, int maxCachedBytesBeforeFlush, long numRetainedInMemoryRegionsMax) {
        this.numBytesPerSegment = numBytesPerSegment;
        this.bufferSizeBytes = bufferSizeBytes;
        this.minReservedDiskSpaceFraction = minReservedDiskSpaceFraction;
        this.regionGroupSizeInBytes = regionGroupSizeInBytes;
        this.maxCachedBytesBeforeFlush = maxCachedBytesBeforeFlush;
        this.numRetainedInMemoryRegionsMax = numRetainedInMemoryRegionsMax;
    }

    @Override
    public TierMasterAgent createMasterAgent(TieredStorageResourceRegistry resourceRegistry) {
        return NoOpMasterAgent.INSTANCE;
    }

    @Override
    public TierProducerAgent createProducerAgent(int numSubpartitions, TieredStoragePartitionId partitionId, String dataFileBasePath, boolean isBroadcastOnly, TieredStorageMemoryManager storageMemoryManager, TieredStorageNettyService nettyService, TieredStorageResourceRegistry resourceRegistry, BatchShuffleReadBufferPool bufferPool, ScheduledExecutorService ioExecutor, int maxRequestedBuffers, Duration bufferRequestTimeout, int maxBufferReadAhead) {
        ProducerMergedPartitionFileIndex partitionFileIndex = new ProducerMergedPartitionFileIndex(isBroadcastOnly ? 1 : numSubpartitions, Paths.get(dataFileBasePath + ".tier-storage.index", new String[0]), this.regionGroupSizeInBytes, this.numRetainedInMemoryRegionsMax);
        Path dataFilePath = Paths.get(dataFileBasePath + ".tier-storage.data", new String[0]);
        ProducerMergedPartitionFileWriter partitionFileWriter = ProducerMergedPartitionFile.createPartitionFileWriter(dataFilePath, partitionFileIndex);
        ProducerMergedPartitionFileReader partitionFileReader = ProducerMergedPartitionFile.createPartitionFileReader(dataFilePath, partitionFileIndex);
        return new DiskTierProducerAgent(partitionId, numSubpartitions, this.numBytesPerSegment, this.bufferSizeBytes, this.maxCachedBytesBeforeFlush, dataFilePath, this.minReservedDiskSpaceFraction, isBroadcastOnly, partitionFileWriter, partitionFileReader, storageMemoryManager, nettyService, resourceRegistry, bufferPool, ioExecutor, maxRequestedBuffers, bufferRequestTimeout, maxBufferReadAhead);
    }

    @Override
    public TierConsumerAgent createConsumerAgent(List<TieredStorageConsumerSpec> tieredStorageConsumerSpecs, TieredStorageNettyService nettyService) {
        return new DiskTierConsumerAgent(tieredStorageConsumerSpecs, nettyService);
    }
}

