/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import org.apache.flink.runtime.io.network.NetworkSequenceViewReader;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.netty.CreditBasedSequenceNumberingViewReader;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionRequestServerHandler
extends SimpleChannelInboundHandler<NettyMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionRequestServerHandler.class);
    private final ResultPartitionProvider partitionProvider;
    private final TaskEventPublisher taskEventPublisher;
    private final PartitionRequestQueue outboundQueue;

    PartitionRequestServerHandler(ResultPartitionProvider partitionProvider, TaskEventPublisher taskEventPublisher, PartitionRequestQueue outboundQueue) {
        this.partitionProvider = partitionProvider;
        this.taskEventPublisher = taskEventPublisher;
        this.outboundQueue = outboundQueue;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, NettyMessage msg) throws Exception {
        try {
            Class<?> msgClazz = msg.getClass();
            if (msgClazz == NettyMessage.PartitionRequest.class) {
                NettyMessage.PartitionRequest request = (NettyMessage.PartitionRequest)msg;
                LOG.debug("Read channel on {}: {}.", (Object)ctx.channel().localAddress(), (Object)request);
                try {
                    CreditBasedSequenceNumberingViewReader reader2 = new CreditBasedSequenceNumberingViewReader(request.receiverId, request.credit, this.outboundQueue);
                    reader2.requestSubpartitionView(this.partitionProvider, request.partitionId, request.queueIndex);
                    this.outboundQueue.notifyReaderCreated(reader2);
                }
                catch (PartitionNotFoundException notFound) {
                    this.respondWithError(ctx, notFound, request.receiverId);
                }
            } else if (msgClazz == NettyMessage.TaskEventRequest.class) {
                NettyMessage.TaskEventRequest request = (NettyMessage.TaskEventRequest)msg;
                if (!this.taskEventPublisher.publish(request.partitionId, request.event)) {
                    this.respondWithError(ctx, new IllegalArgumentException("Task event receiver not found."), request.receiverId);
                }
            } else if (msgClazz == NettyMessage.CancelPartitionRequest.class) {
                NettyMessage.CancelPartitionRequest request = (NettyMessage.CancelPartitionRequest)msg;
                this.outboundQueue.cancel(request.receiverId);
            } else if (msgClazz == NettyMessage.CloseRequest.class) {
                this.outboundQueue.close();
            } else if (msgClazz == NettyMessage.AddCredit.class) {
                NettyMessage.AddCredit request = (NettyMessage.AddCredit)msg;
                this.outboundQueue.addCreditOrResumeConsumption(request.receiverId, reader -> reader.addCredit(request.credit));
            } else if (msgClazz == NettyMessage.ResumeConsumption.class) {
                NettyMessage.ResumeConsumption request = (NettyMessage.ResumeConsumption)msg;
                this.outboundQueue.addCreditOrResumeConsumption(request.receiverId, NetworkSequenceViewReader::resumeConsumption);
            } else if (msgClazz == NettyMessage.AckAllUserRecordsProcessed.class) {
                NettyMessage.AckAllUserRecordsProcessed request = (NettyMessage.AckAllUserRecordsProcessed)msg;
                this.outboundQueue.acknowledgeAllRecordsProcessed(request.receiverId);
            } else if (msgClazz == NettyMessage.NewBufferSize.class) {
                NettyMessage.NewBufferSize request = (NettyMessage.NewBufferSize)msg;
                this.outboundQueue.notifyNewBufferSize(request.receiverId, request.bufferSize);
            } else if (msgClazz == NettyMessage.SegmentId.class) {
                NettyMessage.SegmentId request = (NettyMessage.SegmentId)msg;
                this.outboundQueue.notifyRequiredSegmentId(request.receiverId, request.segmentId);
            } else {
                LOG.warn("Received unexpected client request: {}", (Object)msg);
            }
        }
        catch (Throwable t) {
            this.respondWithError(ctx, t);
        }
    }

    private void respondWithError(ChannelHandlerContext ctx, Throwable error) {
        ctx.writeAndFlush((Object)new NettyMessage.ErrorResponse(error));
    }

    private void respondWithError(ChannelHandlerContext ctx, Throwable error, InputChannelID sourceId) {
        LOG.debug("Responding with error: {}.", error.getClass());
        ctx.writeAndFlush((Object)new NettyMessage.ErrorResponse(error, sourceId));
    }
}

