/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import java.util.Objects;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.spark.source.SparkInputPartition;
import org.apache.iceberg.spark.source.SparkScan;
import org.apache.iceberg.util.TableScanUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;

class SparkBatch
implements Batch {
    private final JavaSparkContext sparkContext;
    private final Table table;
    private final SparkReadConf readConf;
    private final List<CombinedScanTask> taskGroups;
    private final Schema expectedSchema;
    private final boolean caseSensitive;
    private final boolean localityEnabled;
    private final int scanHashCode;

    SparkBatch(JavaSparkContext sparkContext, Table table, SparkReadConf readConf, List<CombinedScanTask> taskGroups, Schema expectedSchema, int scanHashCode) {
        this.sparkContext = sparkContext;
        this.table = table;
        this.readConf = readConf;
        this.taskGroups = taskGroups;
        this.expectedSchema = expectedSchema;
        this.caseSensitive = readConf.caseSensitive();
        this.localityEnabled = readConf.localityEnabled();
        this.scanHashCode = scanHashCode;
    }

    public InputPartition[] planInputPartitions() {
        Broadcast tableBroadcast = this.sparkContext.broadcast((Object)SerializableTableWithSize.copyOf(this.table));
        String expectedSchemaString = SchemaParser.toJson((Schema)this.expectedSchema);
        InputPartition[] partitions = new InputPartition[this.taskGroups.size()];
        Tasks.range((int)partitions.length).stopOnFailure().executeWith(this.localityEnabled ? ThreadPools.getWorkerPool() : null).run(index -> {
            partitions[index.intValue()] = new SparkInputPartition((ScanTaskGroup)this.taskGroups.get((int)index), (Broadcast<Table>)tableBroadcast, expectedSchemaString, this.caseSensitive, this.localityEnabled);
        });
        return partitions;
    }

    public PartitionReaderFactory createReaderFactory() {
        return new SparkScan.ReaderFactory(this.batchSize());
    }

    private int batchSize() {
        if (this.parquetOnly() && this.parquetBatchReadsEnabled()) {
            return this.readConf.parquetBatchSize();
        }
        if (this.orcOnly() && this.orcBatchReadsEnabled()) {
            return this.readConf.orcBatchSize();
        }
        return 0;
    }

    private boolean parquetOnly() {
        return this.taskGroups.stream().allMatch(task -> !task.isDataTask() && this.onlyFileFormat((CombinedScanTask)task, FileFormat.PARQUET));
    }

    private boolean parquetBatchReadsEnabled() {
        return this.readConf.parquetVectorizationEnabled() && this.expectedSchema.columns().size() > 0 && this.expectedSchema.columns().stream().allMatch(c -> c.type().isPrimitiveType());
    }

    private boolean orcOnly() {
        return this.taskGroups.stream().allMatch(task -> !task.isDataTask() && this.onlyFileFormat((CombinedScanTask)task, FileFormat.ORC));
    }

    private boolean orcBatchReadsEnabled() {
        return this.readConf.orcVectorizationEnabled() && this.taskGroups.stream().noneMatch(TableScanUtil::hasDeletes);
    }

    private boolean onlyFileFormat(CombinedScanTask task, FileFormat fileFormat) {
        return task.files().stream().allMatch(fileScanTask -> ((DataFile)fileScanTask.file()).format().equals((Object)fileFormat));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparkBatch that = (SparkBatch)o;
        return this.table.name().equals(that.table.name()) && this.scanHashCode == that.scanHashCode;
    }

    public int hashCode() {
        return Objects.hash(this.table.name(), this.scanHashCode);
    }
}

