/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import java.util.stream.Stream;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.source.BaseBatchReader;
import org.apache.iceberg.spark.source.BaseReader;
import org.apache.spark.rdd.InputFileBlockHolder;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchDataReader
extends BaseBatchReader<FileScanTask> {
    private static final Logger LOG = LoggerFactory.getLogger(BatchDataReader.class);

    BatchDataReader(ScanTaskGroup<FileScanTask> task, Table table, Schema expectedSchema, boolean caseSensitive, int size) {
        super(table, task, expectedSchema, caseSensitive, size);
    }

    @Override
    protected Stream<ContentFile<?>> referencedFiles(FileScanTask task) {
        return Stream.concat(Stream.of(task.file()), task.deletes().stream());
    }

    @Override
    protected CloseableIterator<ColumnarBatch> open(FileScanTask task) {
        String filePath = ((DataFile)task.file()).path().toString();
        LOG.debug("Opening data file {}", (Object)filePath);
        InputFileBlockHolder.set((String)filePath, (long)task.start(), (long)task.length());
        Map<Integer, ?> idToConstant = this.constantsMap((ContentScanTask<?>)task, this.expectedSchema());
        InputFile inputFile = this.getInputFile(filePath);
        Preconditions.checkNotNull((Object)inputFile, (Object)"Could not find InputFile associated with FileScanTask");
        BaseReader.SparkDeleteFilter deleteFilter = task.deletes().isEmpty() ? null : new BaseReader.SparkDeleteFilter(filePath, task.deletes(), this.counter());
        return this.newBatchIterable(inputFile, ((DataFile)task.file()).format(), task.start(), task.length(), task.residual(), idToConstant, deleteFilter).iterator();
    }
}

