/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.List;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ObjectArrays;
import org.apache.iceberg.spark.SortOrderToSpark;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.transforms.SortOrderVisitor;
import org.apache.iceberg.util.SortOrderUtil;
import org.apache.spark.sql.connector.distributions.ClusteredDistribution;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.connector.distributions.UnspecifiedDistribution;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.iceberg.write.RowLevelOperation;

public class SparkDistributionAndOrderingUtil {
    private static final NamedReference SPEC_ID = Expressions.column((String)MetadataColumns.SPEC_ID.name());
    private static final NamedReference PARTITION = Expressions.column((String)"_partition");
    private static final NamedReference FILE_PATH = Expressions.column((String)MetadataColumns.FILE_PATH.name());
    private static final NamedReference ROW_POSITION = Expressions.column((String)MetadataColumns.ROW_POSITION.name());
    private static final org.apache.spark.sql.connector.expressions.SortOrder SPEC_ID_ORDER = Expressions.sort((Expression)SPEC_ID, (SortDirection)SortDirection.ASCENDING);
    private static final org.apache.spark.sql.connector.expressions.SortOrder PARTITION_ORDER = Expressions.sort((Expression)PARTITION, (SortDirection)SortDirection.ASCENDING);
    private static final org.apache.spark.sql.connector.expressions.SortOrder FILE_PATH_ORDER = Expressions.sort((Expression)FILE_PATH, (SortDirection)SortDirection.ASCENDING);
    private static final org.apache.spark.sql.connector.expressions.SortOrder ROW_POSITION_ORDER = Expressions.sort((Expression)ROW_POSITION, (SortDirection)SortDirection.ASCENDING);
    private static final org.apache.spark.sql.connector.expressions.SortOrder[] EXISTING_FILE_ORDERING = new org.apache.spark.sql.connector.expressions.SortOrder[]{FILE_PATH_ORDER, ROW_POSITION_ORDER};
    private static final org.apache.spark.sql.connector.expressions.SortOrder[] POSITION_DELETE_ORDERING = new org.apache.spark.sql.connector.expressions.SortOrder[]{SPEC_ID_ORDER, PARTITION_ORDER, FILE_PATH_ORDER, ROW_POSITION_ORDER};

    private SparkDistributionAndOrderingUtil() {
    }

    public static Distribution buildRequiredDistribution(Table table, DistributionMode distributionMode) {
        switch (distributionMode) {
            case NONE: {
                return Distributions.unspecified();
            }
            case HASH: {
                return Distributions.clustered((Expression[])Spark3Util.toTransforms(table.spec()));
            }
            case RANGE: {
                return Distributions.ordered((org.apache.spark.sql.connector.expressions.SortOrder[])SparkDistributionAndOrderingUtil.buildTableOrdering(table));
            }
        }
        throw new IllegalArgumentException("Unsupported distribution mode: " + distributionMode);
    }

    public static org.apache.spark.sql.connector.expressions.SortOrder[] buildRequiredOrdering(Table table, Distribution distribution) {
        if (distribution instanceof OrderedDistribution) {
            OrderedDistribution orderedDistribution = (OrderedDistribution)distribution;
            return orderedDistribution.ordering();
        }
        return SparkDistributionAndOrderingUtil.buildTableOrdering(table);
    }

    public static Distribution buildCopyOnWriteDistribution(Table table, RowLevelOperation.Command command, DistributionMode distributionMode) {
        if (command == RowLevelOperation.Command.DELETE || command == RowLevelOperation.Command.UPDATE) {
            return SparkDistributionAndOrderingUtil.buildCopyOnWriteDeleteUpdateDistribution(table, distributionMode);
        }
        return SparkDistributionAndOrderingUtil.buildRequiredDistribution(table, distributionMode);
    }

    private static Distribution buildCopyOnWriteDeleteUpdateDistribution(Table table, DistributionMode distributionMode) {
        switch (distributionMode) {
            case NONE: {
                return Distributions.unspecified();
            }
            case HASH: {
                Expression[] clustering = new Expression[]{FILE_PATH};
                return Distributions.clustered((Expression[])clustering);
            }
            case RANGE: {
                Object[] tableOrdering = SparkDistributionAndOrderingUtil.buildTableOrdering(table);
                if (table.sortOrder().isSorted()) {
                    return Distributions.ordered((org.apache.spark.sql.connector.expressions.SortOrder[])tableOrdering);
                }
                org.apache.spark.sql.connector.expressions.SortOrder[] ordering = (org.apache.spark.sql.connector.expressions.SortOrder[])ObjectArrays.concat((Object[])tableOrdering, (Object[])EXISTING_FILE_ORDERING, org.apache.spark.sql.connector.expressions.SortOrder.class);
                return Distributions.ordered((org.apache.spark.sql.connector.expressions.SortOrder[])ordering);
            }
        }
        throw new IllegalArgumentException("Unexpected distribution mode: " + distributionMode);
    }

    public static org.apache.spark.sql.connector.expressions.SortOrder[] buildCopyOnWriteOrdering(Table table, RowLevelOperation.Command command, Distribution distribution) {
        if (command == RowLevelOperation.Command.DELETE || command == RowLevelOperation.Command.UPDATE) {
            return SparkDistributionAndOrderingUtil.buildCopyOnWriteDeleteUpdateOrdering(table, distribution);
        }
        return SparkDistributionAndOrderingUtil.buildRequiredOrdering(table, distribution);
    }

    private static org.apache.spark.sql.connector.expressions.SortOrder[] buildCopyOnWriteDeleteUpdateOrdering(Table table, Distribution distribution) {
        if (distribution instanceof UnspecifiedDistribution) {
            return SparkDistributionAndOrderingUtil.buildTableOrdering(table);
        }
        if (distribution instanceof ClusteredDistribution) {
            Object[] tableOrdering = SparkDistributionAndOrderingUtil.buildTableOrdering(table);
            if (table.sortOrder().isSorted()) {
                return tableOrdering;
            }
            return (org.apache.spark.sql.connector.expressions.SortOrder[])ObjectArrays.concat((Object[])tableOrdering, (Object[])EXISTING_FILE_ORDERING, org.apache.spark.sql.connector.expressions.SortOrder.class);
        }
        if (distribution instanceof OrderedDistribution) {
            OrderedDistribution orderedDistribution = (OrderedDistribution)distribution;
            return orderedDistribution.ordering();
        }
        throw new IllegalArgumentException("Unexpected distribution type: " + distribution.getClass().getName());
    }

    public static Distribution buildPositionDeltaDistribution(Table table, RowLevelOperation.Command command, DistributionMode distributionMode) {
        if (command == RowLevelOperation.Command.DELETE || command == RowLevelOperation.Command.UPDATE) {
            return SparkDistributionAndOrderingUtil.buildPositionDeleteUpdateDistribution(distributionMode);
        }
        return SparkDistributionAndOrderingUtil.buildPositionMergeDistribution(table, distributionMode);
    }

    private static Distribution buildPositionMergeDistribution(Table table, DistributionMode distributionMode) {
        switch (distributionMode) {
            case NONE: {
                return Distributions.unspecified();
            }
            case HASH: {
                if (table.spec().isUnpartitioned()) {
                    Expression[] clustering = new Expression[]{SPEC_ID, PARTITION, FILE_PATH};
                    return Distributions.clustered((Expression[])clustering);
                }
                Distribution dataDistribution = SparkDistributionAndOrderingUtil.buildRequiredDistribution(table, distributionMode);
                Object[] dataClustering = ((ClusteredDistribution)dataDistribution).clustering();
                Object[] deleteClustering = new Expression[]{SPEC_ID, PARTITION};
                Expression[] clustering = (Expression[])ObjectArrays.concat((Object[])deleteClustering, (Object[])dataClustering, Expression.class);
                return Distributions.clustered((Expression[])clustering);
            }
            case RANGE: {
                Distribution dataDistribution = SparkDistributionAndOrderingUtil.buildRequiredDistribution(table, distributionMode);
                Object[] dataOrdering = ((OrderedDistribution)dataDistribution).ordering();
                Object[] deleteOrdering = new org.apache.spark.sql.connector.expressions.SortOrder[]{SPEC_ID_ORDER, PARTITION_ORDER, FILE_PATH_ORDER};
                org.apache.spark.sql.connector.expressions.SortOrder[] ordering = (org.apache.spark.sql.connector.expressions.SortOrder[])ObjectArrays.concat((Object[])deleteOrdering, (Object[])dataOrdering, org.apache.spark.sql.connector.expressions.SortOrder.class);
                return Distributions.ordered((org.apache.spark.sql.connector.expressions.SortOrder[])ordering);
            }
        }
        throw new IllegalArgumentException("Unexpected distribution mode: " + distributionMode);
    }

    private static Distribution buildPositionDeleteUpdateDistribution(DistributionMode distributionMode) {
        switch (distributionMode) {
            case NONE: {
                return Distributions.unspecified();
            }
            case HASH: {
                Expression[] clustering = new Expression[]{SPEC_ID, PARTITION};
                return Distributions.clustered((Expression[])clustering);
            }
            case RANGE: {
                org.apache.spark.sql.connector.expressions.SortOrder[] ordering = new org.apache.spark.sql.connector.expressions.SortOrder[]{SPEC_ID_ORDER, PARTITION_ORDER, FILE_PATH_ORDER};
                return Distributions.ordered((org.apache.spark.sql.connector.expressions.SortOrder[])ordering);
            }
        }
        throw new IllegalArgumentException("Unsupported distribution mode: " + distributionMode);
    }

    public static org.apache.spark.sql.connector.expressions.SortOrder[] buildPositionDeltaOrdering(Table table, RowLevelOperation.Command command) {
        if (command == RowLevelOperation.Command.DELETE || command == RowLevelOperation.Command.UPDATE) {
            return POSITION_DELETE_ORDERING;
        }
        Object[] dataOrdering = SparkDistributionAndOrderingUtil.buildTableOrdering(table);
        return (org.apache.spark.sql.connector.expressions.SortOrder[])ObjectArrays.concat((Object[])POSITION_DELETE_ORDERING, (Object[])dataOrdering, org.apache.spark.sql.connector.expressions.SortOrder.class);
    }

    public static org.apache.spark.sql.connector.expressions.SortOrder[] convert(SortOrder sortOrder) {
        List converted = SortOrderVisitor.visit((SortOrder)sortOrder, (SortOrderVisitor)new SortOrderToSpark(sortOrder.schema()));
        return converted.toArray(new org.apache.spark.sql.connector.expressions.SortOrder[0]);
    }

    private static org.apache.spark.sql.connector.expressions.SortOrder[] buildTableOrdering(Table table) {
        return SparkDistributionAndOrderingUtil.convert(SortOrderUtil.buildSortOrder((Table)table));
    }
}

