/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRewriteCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(FileRewriteCoordinator.class);
    private static final FileRewriteCoordinator INSTANCE = new FileRewriteCoordinator();
    private final Map<Pair<String, String>, Set<DataFile>> resultMap = Maps.newConcurrentMap();

    private FileRewriteCoordinator() {
    }

    public static FileRewriteCoordinator get() {
        return INSTANCE;
    }

    public void stageRewrite(Table table, String fileSetID, Set<DataFile> newDataFiles) {
        LOG.debug("Staging the output for {} - fileset {} with {} files", new Object[]{table.name(), fileSetID, newDataFiles.size()});
        Pair<String, String> id = this.toID(table, fileSetID);
        this.resultMap.put(id, newDataFiles);
    }

    public Set<DataFile> fetchNewDataFiles(Table table, String fileSetID) {
        Pair<String, String> id = this.toID(table, fileSetID);
        Set<DataFile> result = this.resultMap.get(id);
        ValidationException.check((result != null ? 1 : 0) != 0, (String)"No results for rewrite of file set %s in table %s", (Object[])new Object[]{fileSetID, table});
        return result;
    }

    public void clearRewrite(Table table, String fileSetID) {
        LOG.debug("Removing entry from RewriteCoordinator for {} - id {}", (Object)table.name(), (Object)fileSetID);
        Pair<String, String> id = this.toID(table, fileSetID);
        this.resultMap.remove(id);
    }

    public Set<String> fetchSetIDs(Table table) {
        return this.resultMap.keySet().stream().filter(e -> ((String)e.first()).equals(this.tableUUID(table))).map(Pair::second).collect(Collectors.toSet());
    }

    private Pair<String, String> toID(Table table, String setID) {
        String tableUUID = this.tableUUID(table);
        return Pair.of((Object)tableUUID, (Object)setID);
    }

    private String tableUUID(Table table) {
        TableOperations ops = ((HasTableOperations)table).operations();
        return ops.current().uuid();
    }
}

