/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.spark.GetMapAndMergeResultStatuses;
import org.apache.spark.GetMapOutputStatuses;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.MapOutputTracker$;
import org.apache.spark.MapSizesByExecutorId;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MergeStatus;
import org.apache.spark.shuffle.MetadataFetchFailedException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.KeyLock;
import org.apache.spark.util.Utils$;
import org.roaringbitmap.RoaringBitmap;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed!\u0002\n\u0014\u0001MI\u0002\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\t\u000b\r\u0002A\u0011\u0001\u0013\t\u000f\u001d\u0002!\u0019!C\u0001Q!1\u0001\t\u0001Q\u0001\n%Bq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004I\u0001\u0001\u0006Ia\u0011\u0005\t\u0013\u0002A)\u0019!C\u0005\u0015\"9a\n\u0001b\u0001\n\u0013y\u0005B\u0002,\u0001A\u0003%\u0001\u000bC\u0003X\u0001\u0011\u0005\u0003\fC\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !9\u0011q\u0006\u0001\u0005B\u0005E\u0002bBA\u0018\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u0003\u001f\u0002A\u0011BA)\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!!\u001b\u0001\t\u0003\tYG\u0001\fNCB|U\u000f\u001e9viR\u0013\u0018mY6fe^{'o[3s\u0015\t!R#A\u0003ta\u0006\u00148N\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7C\u0001\u0001\u001b!\tYB$D\u0001\u0014\u0013\ti2C\u0001\tNCB|U\u000f\u001e9viR\u0013\u0018mY6fe\u0006!1m\u001c8g\u0007\u0001\u0001\"aG\u0011\n\u0005\t\u001a\"!C*qCJ\\7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0011QE\n\t\u00037\u0001AQA\b\u0002A\u0002\u0001\n1\"\\1q'R\fG/^:fgV\t\u0011\u0006\u0005\u0003+cM:T\"A\u0016\u000b\u00051j\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003]=\n!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a,\u0005\ri\u0015\r\u001d\t\u0003iUj\u0011aL\u0005\u0003m=\u00121!\u00138u!\r!\u0004HO\u0005\u0003s=\u0012Q!\u0011:sCf\u0004\"a\u000f \u000e\u0003qR!!P\n\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018BA =\u0005%i\u0015\r]*uCR,8/\u0001\u0007nCB\u001cF/\u0019;vg\u0016\u001c\b%A\u0007nKJ<Wm\u0015;biV\u001cXm]\u000b\u0002\u0007B!!&M\u001aE!\r!\u0004(\u0012\t\u0003w\u0019K!a\u0012\u001f\u0003\u00175+'oZ3Ti\u0006$Xo]\u0001\u000f[\u0016\u0014x-Z*uCR,8/Z:!\u0003A1W\r^2i\u001b\u0016\u0014x-\u001a*fgVdG/F\u0001L!\t!D*\u0003\u0002N_\t9!i\\8mK\u0006t\u0017\u0001\u00044fi\u000eD\u0017N\\4M_\u000e\\W#\u0001)\u0011\u0007E#6'D\u0001S\u0015\t\u00196#\u0001\u0003vi&d\u0017BA+S\u0005\u001dYU-\u001f'pG.\fQBZ3uG\"Lgn\u001a'pG.\u0004\u0013aF4fi6\u000b\u0007oU5{KN\u0014\u00150\u0012=fGV$xN]%e)!I&\u0010 @\u0002\u0002\u0005\u0015\u0001c\u0001.cK:\u00111\f\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=~\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0019\n\u0005\u0005|\u0013a\u00029bG.\fw-Z\u0005\u0003G\u0012\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003C>\u0002B\u0001\u000e4i]&\u0011qm\f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005%dW\"\u00016\u000b\u0005-\u001c\u0012aB:u_J\fw-Z\u0005\u0003[*\u0014aB\u00117pG.l\u0015M\\1hKJLE\rE\u0002[_FL!\u0001\u001d3\u0003\u0007M+\u0017\u000fE\u00035eR<8'\u0003\u0002t_\t1A+\u001e9mKN\u0002\"![;\n\u0005YT'a\u0002\"m_\u000e\\\u0017\n\u001a\t\u0003iaL!!_\u0018\u0003\t1{gn\u001a\u0005\u0006w*\u0001\raM\u0001\ng\",hM\u001a7f\u0013\u0012DQ! \u0006A\u0002M\nQb\u001d;beRl\u0015\r]%oI\u0016D\b\"B@\u000b\u0001\u0004\u0019\u0014aC3oI6\u000b\u0007/\u00138eKbDa!a\u0001\u000b\u0001\u0004\u0019\u0014AD:uCJ$\b+\u0019:uSRLwN\u001c\u0005\u0007\u0003\u000fQ\u0001\u0019A\u001a\u0002\u0019\u0015tG\rU1si&$\u0018n\u001c8\u0002O\u001d,G\u000fU;tQ\n\u000b7/\u001a3TQV4g\r\\3NCB\u001c\u0016N_3t\u0005f,\u00050Z2vi>\u0014\u0018\n\u001a\u000b\r\u0003\u001b\t\u0019\"!\u0006\u0002\u0018\u0005e\u00111\u0004\t\u00047\u0005=\u0011bAA\t'\t!R*\u00199TSj,7OQ=Fq\u0016\u001cW\u000f^8s\u0013\u0012DQa_\u0006A\u0002MBQ!`\u0006A\u0002MBQa`\u0006A\u0002MBa!a\u0001\f\u0001\u0004\u0019\u0004BBA\u0004\u0017\u0001\u00071'A\u000ehKRl\u0015\r]*ju\u0016\u001c()_#yK\u000e,Ho\u001c:JI&k\u0007\u000f\u001c\u000b\u000f\u0003\u001b\t\t#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0011\u0015YH\u00021\u00014\u0011\u0015iH\u00021\u00014\u0011\u0015yH\u00021\u00014\u0011\u0019\t\u0019\u0001\u0004a\u0001g!1\u0011q\u0001\u0007A\u0002MBa!!\f\r\u0001\u0004Y\u0015AD;tK6+'oZ3SKN,H\u000e^\u0001\u001aO\u0016$X*\u00199TSj,7OR8s\u001b\u0016\u0014x-\u001a*fgVdG\u000fF\u0003Z\u0003g\t)\u0004C\u0003|\u001b\u0001\u00071\u0007\u0003\u0004\u000285\u0001\raM\u0001\fa\u0006\u0014H/\u001b;j_:LE\rF\u0004Z\u0003w\ti$a\u0010\t\u000bmt\u0001\u0019A\u001a\t\r\u0005]b\u00021\u00014\u0011\u001d\t\tE\u0004a\u0001\u0003\u0007\nAb\u00195v].$&/Y2lKJ\u0004B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013:\u0012!\u0004:pCJLgn\u001a2ji6\f\u0007/\u0003\u0003\u0002N\u0005\u001d#!\u0004*pCJLgn\u001a\"ji6\f\u0007/A\u0006hKR\u001cF/\u0019;vg\u0016\u001cH\u0003CA*\u0003+\n9&!\u0017\u0011\tQ2w\u0007\u0012\u0005\u0006w>\u0001\ra\r\u0005\u0006==\u0001\r\u0001\t\u0005\u0007\u00037z\u0001\u0019A&\u0002'\r\fgNR3uG\"lUM]4f%\u0016\u001cX\u000f\u001c;\u0002#Ut'/Z4jgR,'o\u00155vM\u001adW\r\u0006\u0003\u0002b\u0005\u001d\u0004c\u0001\u001b\u0002d%\u0019\u0011QM\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u0006wB\u0001\raM\u0001\fkB$\u0017\r^3Fa>\u001c\u0007\u000e\u0006\u0003\u0002b\u00055\u0004BBA8#\u0001\u0007q/\u0001\u0005oK^,\u0005o\\2i\u0001")
public class MapOutputTrackerWorker
extends MapOutputTracker {
    private boolean fetchMergeResult;
    private final SparkConf conf;
    private final Map<Object, MapStatus[]> mapStatuses;
    private final Map<Object, MergeStatus[]> mergeStatuses;
    private final KeyLock<Object> fetchingLock;
    private volatile boolean bitmap$0;

    public Map<Object, MapStatus[]> mapStatuses() {
        return this.mapStatuses;
    }

    public Map<Object, MergeStatus[]> mergeStatuses() {
        return this.mergeStatuses;
    }

    private boolean fetchMergeResult$lzycompute() {
        MapOutputTrackerWorker mapOutputTrackerWorker = this;
        synchronized (mapOutputTrackerWorker) {
            if (!this.bitmap$0) {
                this.fetchMergeResult = Utils$.MODULE$.isPushBasedShuffleEnabled(this.conf, false, Utils$.MODULE$.isPushBasedShuffleEnabled$default$3());
                this.bitmap$0 = true;
            }
        }
        return this.fetchMergeResult;
    }

    private boolean fetchMergeResult() {
        return !this.bitmap$0 ? this.fetchMergeResult$lzycompute() : this.fetchMergeResult;
    }

    private KeyLock<Object> fetchingLock() {
        return this.fetchingLock;
    }

    @Override
    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapSizesByExecutorId(int shuffleId, int startMapIndex, int endMapIndex, int startPartition, int endPartition) {
        MapSizesByExecutorId mapSizesByExecutorId = this.getMapSizesByExecutorIdImpl(shuffleId, startMapIndex, endMapIndex, startPartition, endPartition, false);
        Predef$.MODULE$.assert(mapSizesByExecutorId.enableBatchFetch());
        return mapSizesByExecutorId.iter();
    }

    @Override
    public MapSizesByExecutorId getPushBasedShuffleMapSizesByExecutorId(int shuffleId, int startMapIndex, int endMapIndex, int startPartition, int endPartition) {
        return this.getMapSizesByExecutorIdImpl(shuffleId, startMapIndex, endMapIndex, startPartition, endPartition, true);
    }

    private MapSizesByExecutorId getMapSizesByExecutorIdImpl(int shuffleId, int startMapIndex, int endMapIndex, int startPartition, int endPartition, boolean useMergeResult) {
        MapSizesByExecutorId mapSizesByExecutorId;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Fetching outputs for shuffle ").append(shuffleId).toString());
        Tuple2<MapStatus[], MergeStatus[]> tuple2 = this.getStatuses(shuffleId, this.conf, useMergeResult ? this.fetchMergeResult() : false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MapStatus[] mapOutputStatuses = (MapStatus[])tuple2._1();
        MergeStatus[] mergedOutputStatuses = (MergeStatus[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)mapOutputStatuses, (Object)mergedOutputStatuses);
        Tuple2 tuple23 = tuple22;
        MapStatus[] mapOutputStatuses2 = (MapStatus[])tuple23._1();
        MergeStatus[] mergedOutputStatuses2 = (MergeStatus[])tuple23._2();
        try {
            int actualEndMapIndex = endMapIndex == Integer.MAX_VALUE ? mapOutputStatuses2.length : endMapIndex;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Convert map statuses for shuffle ").append(shuffleId).append(", ").append("mappers ").append(startMapIndex).append("-").append(actualEndMapIndex).append(", partitions ").append(startPartition).append("-").append(endPartition).toString());
            mapSizesByExecutorId = MapOutputTracker$.MODULE$.convertMapStatuses(shuffleId, startPartition, endPartition, mapOutputStatuses2, startMapIndex, actualEndMapIndex, (Option<MergeStatus[]>)Option$.MODULE$.apply((Object)mergedOutputStatuses2));
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            this.mergeStatuses().clear();
            throw e;
        }
        return mapSizesByExecutorId;
    }

    @Override
    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapSizesForMergeResult(int shuffleId, int partitionId) {
        Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> iterator;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Fetching backup outputs for shuffle ").append(shuffleId).append(", partition ").append(partitionId).toString());
        Tuple2<MapStatus[], MergeStatus[]> tuple2 = this.getStatuses(shuffleId, this.conf, this.fetchMergeResult());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MapStatus[] mapOutputStatuses = (MapStatus[])tuple2._1();
        MergeStatus[] mergeResultStatuses = (MergeStatus[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)mapOutputStatuses, (Object)mergeResultStatuses);
        Tuple2 tuple23 = tuple22;
        MapStatus[] mapOutputStatuses2 = (MapStatus[])tuple23._1();
        MergeStatus[] mergeResultStatuses2 = (MergeStatus[])tuple23._2();
        try {
            MergeStatus mergeStatus = mergeResultStatuses2[partitionId];
            MapOutputTracker$.MODULE$.validateStatus(mergeStatus, shuffleId, partitionId);
            iterator = MapOutputTracker$.MODULE$.getMapStatusesForMergeStatus(shuffleId, partitionId, mapOutputStatuses2, mergeStatus.tracker());
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            this.mergeStatuses().clear();
            throw e;
        }
        return iterator;
    }

    @Override
    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapSizesForMergeResult(int shuffleId, int partitionId, RoaringBitmap chunkTracker) {
        Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> iterator;
        MapStatus[] mapOutputStatuses;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Fetching backup outputs for shuffle ").append(shuffleId).append(", partition ").append(partitionId).toString());
        Tuple2<MapStatus[], MergeStatus[]> tuple2 = this.getStatuses(shuffleId, this.conf, this.fetchMergeResult());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MapStatus[] mapStatusArray = mapOutputStatuses = (MapStatus[])tuple2._1();
        MapStatus[] mapOutputStatuses2 = mapStatusArray;
        try {
            iterator = MapOutputTracker$.MODULE$.getMapStatusesForMergeStatus(shuffleId, partitionId, mapOutputStatuses2, chunkTracker);
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            this.mergeStatuses().clear();
            throw e;
        }
        return iterator;
    }

    private Tuple2<MapStatus[], MergeStatus[]> getStatuses(int shuffleId, SparkConf conf, boolean canFetchMergeResult) {
        Tuple2 tuple2;
        if (canFetchMergeResult) {
            MapStatus[] mapOutputStatuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
            MergeStatus[] mergeOutputStatuses = (MergeStatus[])this.mergeStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
            if (mapOutputStatuses == null || mergeOutputStatuses == null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Don't have map/merge outputs for shuffle ").append(shuffleId).append(", fetching them").toString());
                long startTimeNs = System.nanoTime();
                tuple2 = (Tuple2)this.fetchingLock().withLock(BoxesRunTime.boxToInteger((int)shuffleId), (Function0 & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    MapStatus[] fetchedMapStatuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
                    MergeStatus[] fetchedMergeStatuses = (MergeStatus[])this.mergeStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
                    if (fetchedMapStatuses == null || fetchedMergeStatuses == null) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Doing the fetch; tracker endpoint = ").append(this.trackerEndpoint()).toString());
                        Tuple2 fetchedBytes = (Tuple2)this.askTracker(new GetMapAndMergeResultStatuses(shuffleId), ClassTag$.MODULE$.apply(Tuple2.class));
                        try {
                            fetchedMapStatuses = (MapStatus[])MapOutputTracker$.MODULE$.deserializeOutputStatuses((byte[])fetchedBytes._1(), conf);
                            fetchedMergeStatuses = (MergeStatus[])MapOutputTracker$.MODULE$.deserializeOutputStatuses((byte[])fetchedBytes._2(), conf);
                        }
                        catch (SparkException e) {
                            throw new MetadataFetchFailedException(shuffleId, -1, new StringBuilder(67).append("Unable to deserialize broadcasted map/merge statuses").append(" for shuffle ").append(shuffleId).append(": ").append(e.getCause()).toString());
                        }
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got the map/merge output locations");
                        this.mapStatuses().put((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedMapStatuses);
                        boxedUnit = this.mergeStatuses().put((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedMergeStatuses);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Fetching map/merge output statuses for shuffle ").append(shuffleId).append(" took ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs)).append(" ms").toString());
                    return new Tuple2((Object)fetchedMapStatuses, (Object)fetchedMergeStatuses);
                });
            } else {
                tuple2 = new Tuple2((Object)mapOutputStatuses, (Object)mergeOutputStatuses);
            }
        } else {
            MapStatus[] statuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
            if (statuses == null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Don't have map outputs for shuffle ").append(shuffleId).append(", fetching them").toString());
                long startTimeNs = System.nanoTime();
                tuple2 = (Tuple2)this.fetchingLock().withLock(BoxesRunTime.boxToInteger((int)shuffleId), (Function0 & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    MapStatus[] fetchedStatuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
                    if (fetchedStatuses == null) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Doing the fetch; tracker endpoint = ").append(this.trackerEndpoint()).toString());
                        byte[] fetchedBytes = (byte[])this.askTracker(new GetMapOutputStatuses(shuffleId), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                        try {
                            fetchedStatuses = (MapStatus[])MapOutputTracker$.MODULE$.deserializeOutputStatuses(fetchedBytes, conf);
                        }
                        catch (SparkException e) {
                            throw new MetadataFetchFailedException(shuffleId, -1, new StringBuilder(61).append("Unable to deserialize broadcasted map statuses for shuffle ").append(shuffleId).append(": ").append(e.getCause()).toString());
                        }
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got the map output locations");
                        boxedUnit = this.mapStatuses().put((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedStatuses);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Fetching map output statuses for shuffle ").append(shuffleId).append(" took ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs)).append(" ms").toString());
                    return new Tuple2((Object)fetchedStatuses, null);
                });
            } else {
                tuple2 = new Tuple2((Object)statuses, null);
            }
        }
        return tuple2;
    }

    @Override
    public void unregisterShuffle(int shuffleId) {
        this.mapStatuses().remove((Object)BoxesRunTime.boxToInteger((int)shuffleId));
        this.mergeStatuses().remove((Object)BoxesRunTime.boxToInteger((int)shuffleId));
    }

    public void updateEpoch(long newEpoch) {
        Object object = this.epochLock();
        synchronized (object) {
            if (newEpoch > this.epoch()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Updating epoch to ").append(newEpoch).append(" and clearing cache").toString());
                this.epoch_$eq(newEpoch);
                this.mapStatuses().clear();
                this.mergeStatuses().clear();
            }
        }
    }

    public MapOutputTrackerWorker(SparkConf conf) {
        this.conf = conf;
        super(conf);
        this.mapStatuses = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.mergeStatuses = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.fetchingLock = new KeyLock();
    }
}

