/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.hive.table.SupportHive;
import org.apache.amoro.hive.utils.TableTypeUtil;
import org.apache.amoro.server.optimizing.OptimizingType;
import org.apache.amoro.server.optimizing.plan.AbstractPartitionPlan;
import org.apache.amoro.server.optimizing.plan.IcebergPartitionPlan;
import org.apache.amoro.server.optimizing.plan.MixedHivePartitionPlan;
import org.apache.amoro.server.optimizing.plan.MixedIcebergPartitionPlan;
import org.apache.amoro.server.optimizing.plan.OptimizingEvaluator;
import org.apache.amoro.server.optimizing.plan.PartitionEvaluator;
import org.apache.amoro.server.optimizing.plan.TaskDescriptor;
import org.apache.amoro.server.table.KeyedTableSnapshot;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.ExpressionUtil;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizingPlanner
extends OptimizingEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizingPlanner.class);
    private final Expression partitionFilter;
    protected long processId;
    private final double availableCore;
    private final long planTime;
    private OptimizingType optimizingType;
    private final PartitionPlannerFactory partitionPlannerFactory;
    private List<TaskDescriptor> tasks;
    private List<AbstractPartitionPlan> actualPartitionPlans;
    private final long maxInputSizePerThread;

    public OptimizingPlanner(TableRuntime tableRuntime, MixedTable table, double availableCore, long maxInputSizePerThread) {
        super(tableRuntime, table);
        this.partitionFilter = tableRuntime.getPendingInput() == null ? Expressions.alwaysTrue() : tableRuntime.getPendingInput().getPartitions().entrySet().stream().map(entry -> ExpressionUtil.convertPartitionDataToDataFilter((MixedTable)table, (int)((Integer)entry.getKey()), (Collection)((Collection)entry.getValue()))).reduce(Expressions::or).orElse((Expression)Expressions.alwaysTrue());
        this.availableCore = availableCore;
        this.planTime = System.currentTimeMillis();
        this.processId = Math.max(tableRuntime.getNewestProcessId() + 1L, this.planTime);
        this.partitionPlannerFactory = new PartitionPlannerFactory(this.mixedTable, tableRuntime, this.planTime);
        this.maxInputSizePerThread = maxInputSizePerThread;
    }

    @Override
    protected PartitionEvaluator buildEvaluator(Pair<Integer, StructLike> partition) {
        return this.partitionPlannerFactory.buildPartitionPlanner(partition);
    }

    public Map<String, Long> getFromSequence() {
        return this.actualPartitionPlans.stream().filter(p -> p.getFromSequence() != null).collect(Collectors.toMap(partitionPlan -> {
            Pair<Integer, StructLike> partition = partitionPlan.getPartition();
            PartitionSpec spec = MixedTableUtil.getMixedTablePartitionSpecById((MixedTable)this.mixedTable, (int)((Integer)partition.first()));
            return spec.partitionToPath((StructLike)partition.second());
        }, AbstractPartitionPlan::getFromSequence));
    }

    public Map<String, Long> getToSequence() {
        return this.actualPartitionPlans.stream().filter(p -> p.getToSequence() != null).collect(Collectors.toMap(partitionPlan -> {
            Pair<Integer, StructLike> partition = partitionPlan.getPartition();
            PartitionSpec spec = MixedTableUtil.getMixedTablePartitionSpecById((MixedTable)this.mixedTable, (int)((Integer)partition.first()));
            return spec.partitionToPath((StructLike)partition.second());
        }, AbstractPartitionPlan::getToSequence));
    }

    @Override
    protected Expression getPartitionFilter() {
        return this.partitionFilter;
    }

    public long getTargetSnapshotId() {
        return this.currentSnapshot.snapshotId();
    }

    public long getTargetChangeSnapshotId() {
        if (this.currentSnapshot instanceof KeyedTableSnapshot) {
            return ((KeyedTableSnapshot)this.currentSnapshot).changeSnapshotId();
        }
        return -1L;
    }

    @Override
    public boolean isNecessary() {
        if (!super.isNecessary()) {
            return false;
        }
        return !this.planTasks().isEmpty();
    }

    public List<TaskDescriptor> planTasks() {
        if (this.tasks != null) {
            return this.tasks;
        }
        long startTime = System.nanoTime();
        if (!this.isInitialized) {
            this.initEvaluator();
        }
        if (!super.isNecessary()) {
            LOG.debug("Table {} skip planning", (Object)this.tableRuntime.getTableIdentifier());
            return this.cacheAndReturnTasks(Collections.emptyList());
        }
        ArrayList evaluators = new ArrayList(this.partitionPlanMap.values());
        evaluators.sort(Comparator.comparing(PartitionEvaluator::getWeight, Comparator.reverseOrder()));
        double maxInputSize = (double)this.maxInputSizePerThread * this.availableCore;
        this.actualPartitionPlans = Lists.newArrayList();
        long actualInputSize = 0L;
        for (PartitionEvaluator evaluator2 : evaluators) {
            this.actualPartitionPlans.add((AbstractPartitionPlan)evaluator2);
            if (!((double)(actualInputSize += evaluator2.getCost()) > maxInputSize)) continue;
            break;
        }
        double avgThreadCost = (double)actualInputSize / this.availableCore;
        ArrayList tasks = Lists.newArrayList();
        for (AbstractPartitionPlan partitionPlan : this.actualPartitionPlans) {
            tasks.addAll(partitionPlan.splitTasks((int)((double)actualInputSize / avgThreadCost)));
        }
        if (!tasks.isEmpty()) {
            this.optimizingType = evaluators.stream().anyMatch(evaluator -> evaluator.getOptimizingType() == OptimizingType.FULL) ? OptimizingType.FULL : (evaluators.stream().anyMatch(evaluator -> evaluator.getOptimizingType() == OptimizingType.MAJOR) ? OptimizingType.MAJOR : OptimizingType.MINOR);
        }
        long endTime = System.nanoTime();
        LOG.info("{} finish plan, type = {}, get {} tasks, cost {} ns, {} ms maxInputSize {} actualInputSize {}", new Object[]{this.tableRuntime.getTableIdentifier(), this.getOptimizingType(), tasks.size(), endTime - startTime, (endTime - startTime) / 1000000L, maxInputSize, actualInputSize});
        return this.cacheAndReturnTasks(tasks);
    }

    private List<TaskDescriptor> cacheAndReturnTasks(List<TaskDescriptor> tasks) {
        this.tasks = tasks;
        return this.tasks;
    }

    public long getPlanTime() {
        return this.planTime;
    }

    public OptimizingType getOptimizingType() {
        return this.optimizingType;
    }

    public long getProcessId() {
        return this.processId;
    }

    private static class PartitionPlannerFactory {
        private final MixedTable mixedTable;
        private final TableRuntime tableRuntime;
        private final String hiveLocation;
        private final long planTime;

        public PartitionPlannerFactory(MixedTable mixedTable, TableRuntime tableRuntime, long planTime) {
            this.mixedTable = mixedTable;
            this.tableRuntime = tableRuntime;
            this.planTime = planTime;
            this.hiveLocation = TableTypeUtil.isHive((MixedTable)mixedTable) ? ((SupportHive)mixedTable).hiveLocation() : null;
        }

        public PartitionEvaluator buildPartitionPlanner(Pair<Integer, StructLike> partition) {
            if (TableFormat.ICEBERG == this.mixedTable.format()) {
                return new IcebergPartitionPlan(this.tableRuntime, this.mixedTable, partition, this.planTime);
            }
            if (TableTypeUtil.isHive((MixedTable)this.mixedTable)) {
                return new MixedHivePartitionPlan(this.tableRuntime, this.mixedTable, partition, this.hiveLocation, this.planTime);
            }
            return new MixedIcebergPartitionPlan(this.tableRuntime, this.mixedTable, partition, this.planTime);
        }
    }
}

