/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing.plan;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.optimizing.IcebergRewriteExecutorFactory;
import org.apache.amoro.optimizing.OptimizingInputProperties;
import org.apache.amoro.server.optimizing.plan.AbstractPartitionPlan;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.util.Pair;

public class IcebergPartitionPlan
extends AbstractPartitionPlan {
    protected IcebergPartitionPlan(TableRuntime tableRuntime, MixedTable table, Pair<Integer, StructLike> partition, long planTime) {
        super(tableRuntime, table, partition, planTime);
    }

    @Override
    protected AbstractPartitionPlan.TaskSplitter buildTaskSplitter() {
        return new AbstractPartitionPlan.BinPackingTaskSplitter();
    }

    @Override
    protected OptimizingInputProperties buildTaskProperties() {
        OptimizingInputProperties properties = new OptimizingInputProperties();
        properties.setExecutorFactoryImpl(IcebergRewriteExecutorFactory.class.getName());
        return properties;
    }

    @Override
    protected List<AbstractPartitionPlan.SplitTask> filterSplitTasks(List<AbstractPartitionPlan.SplitTask> splitTasks) {
        return splitTasks.stream().filter(this::enoughInputFiles).collect(Collectors.toList());
    }

    protected boolean enoughInputFiles(AbstractPartitionPlan.SplitTask splitTask) {
        boolean only1DataFile = splitTask.getRewriteDataFiles().size() == 1 && splitTask.getRewritePosDataFiles().size() == 0 && splitTask.getDeleteFiles().size() == 0;
        return !only1DataFile;
    }
}

