/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.manager;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.amoro.api.events.Event;
import org.apache.amoro.api.events.EventListener;
import org.apache.amoro.server.manager.AbstractPluginManager;

public class EventsManager
extends AbstractPluginManager<EventListener> {
    public static final String PLUGIN_TYPE = "event-listeners";
    private static volatile EventsManager INSTANCE;
    private Executor pluginVisitorPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventsManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<EventsManager> clazz = EventsManager.class;
        synchronized (EventsManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new EventsManager();
            INSTANCE.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        Class<EventsManager> clazz = EventsManager.class;
        synchronized (EventsManager.class) {
            if (INSTANCE != null) {
                INSTANCE.close();
            }
            INSTANCE = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public EventsManager() {
        super(PLUGIN_TYPE);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.pluginVisitorPool = new ThreadPoolExecutor(0, 1, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("PluginVisitor-" + this.pluginCategory() + "-0");
            thread.setDaemon(true);
            return thread;
        });
    }

    @Override
    protected String pluginCategory() {
        return PLUGIN_TYPE;
    }

    public void emit(Event event) {
        this.pluginVisitorPool.execute(() -> this.forEach(listener -> listener.handleEvent(event)));
    }
}

