/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.utils;

import org.apache.amoro.server.dashboard.model.FilesStatistics;
import org.apache.amoro.server.dashboard.model.TableOptimizingInfo;
import org.apache.amoro.server.optimizing.MetricsSummary;
import org.apache.amoro.server.optimizing.OptimizingProcess;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.optimizing.plan.OptimizingEvaluator;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.iceberg.ContentFile;

public class OptimizingUtil {
    public static TableOptimizingInfo buildTableOptimizeInfo(TableRuntime optimizingTableRuntime) {
        OptimizingProcess process = optimizingTableRuntime.getOptimizingProcess();
        TableOptimizingInfo tableOptimizeInfo = new TableOptimizingInfo(optimizingTableRuntime.getTableIdentifier());
        tableOptimizeInfo.setOptimizeStatus(optimizingTableRuntime.getOptimizingStatus().displayValue());
        tableOptimizeInfo.setDuration(System.currentTimeMillis() - optimizingTableRuntime.getCurrentStatusStartTime());
        tableOptimizeInfo.setQuota(optimizingTableRuntime.getTargetQuota());
        tableOptimizeInfo.setQuotaOccupation(optimizingTableRuntime.calculateQuotaOccupy());
        FilesStatistics optimizeFileInfo = optimizingTableRuntime.getOptimizingStatus().isProcessing() ? OptimizingUtil.collectOptimizingFileInfo(process == null ? null : process.getSummary()) : (optimizingTableRuntime.getOptimizingStatus() == OptimizingStatus.PENDING ? OptimizingUtil.collectPendingFileInfo(optimizingTableRuntime.getPendingInput()) : null);
        if (optimizeFileInfo != null) {
            tableOptimizeInfo.setFileCount(optimizeFileInfo.getFileCnt());
            tableOptimizeInfo.setFileSize(optimizeFileInfo.getTotalSize());
        }
        tableOptimizeInfo.setGroupName(optimizingTableRuntime.getOptimizerGroup());
        return tableOptimizeInfo;
    }

    private static FilesStatistics collectPendingFileInfo(OptimizingEvaluator.PendingInput pendingInput) {
        if (pendingInput == null) {
            return null;
        }
        return FilesStatistics.builder().addFiles(pendingInput.getDataFileSize(), pendingInput.getDataFileCount()).addFiles(pendingInput.getEqualityDeleteBytes(), pendingInput.getEqualityDeleteFileCount()).addFiles(pendingInput.getPositionalDeleteBytes(), pendingInput.getPositionalDeleteFileCount()).build();
    }

    private static FilesStatistics collectOptimizingFileInfo(MetricsSummary metricsSummary) {
        if (metricsSummary == null) {
            return null;
        }
        return FilesStatistics.builder().addFiles(metricsSummary.getEqualityDeleteSize(), metricsSummary.getEqDeleteFileCnt()).addFiles(Math.max(metricsSummary.getPositionalDeleteSize(), metricsSummary.getPositionDeleteSize()), metricsSummary.getPosDeleteFileCnt()).addFiles(metricsSummary.getRewriteDataSize(), metricsSummary.getRewriteDataFileCnt()).build();
    }

    public static long getFileSize(ContentFile<?>[] contentFiles) {
        long size = 0L;
        if (contentFiles != null) {
            for (ContentFile<?> contentFile : contentFiles) {
                size += contentFile.fileSizeInBytes();
            }
        }
        return size;
    }

    public static int getFileCount(ContentFile<?>[] contentFiles) {
        return contentFiles == null ? 0 : contentFiles.length;
    }

    public static long getRecordCnt(ContentFile<?>[] contentFiles) {
        int recordCnt = 0;
        if (contentFiles != null) {
            for (ContentFile<?> contentFile : contentFiles) {
                recordCnt = (int)((long)recordCnt + contentFile.recordCount());
            }
        }
        return recordCnt;
    }
}

