/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.api.resource;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.amoro.api.OptimizerRegisterInfo;
import org.apache.amoro.api.resource.ResourceType;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;

public class Resource {
    public static final String PROPERTY_JOB_ID = "job-id";
    private String resourceId;
    private String containerName;
    private String groupName;
    private int threadCount;
    private int memoryMb;
    private Map<String, String> properties;
    private ResourceType type;

    protected Resource() {
    }

    private Resource(Builder builder) {
        this.resourceId = builder.resourceId;
        this.containerName = builder.containerName;
        this.groupName = builder.groupName;
        this.threadCount = builder.threadCount;
        this.memoryMb = builder.memoryMb;
        this.properties = builder.properties;
        this.type = builder.type;
    }

    protected Resource(OptimizerRegisterInfo registerInfo, String containerName) {
        this.resourceId = registerInfo.getResourceId();
        this.groupName = registerInfo.getGroupName();
        this.threadCount = registerInfo.getThreadCount();
        this.memoryMb = registerInfo.getMemoryMb();
        this.properties = registerInfo.getProperties();
        this.type = ResourceType.OPTIMIZER;
        this.containerName = containerName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getMemoryMb() {
        return this.memoryMb;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getRequiredProperty(String key) {
        Preconditions.checkState((this.properties != null && this.properties.containsKey(key) ? 1 : 0) != 0, (String)"Cannot find %s in properties", (Object)key);
        String value = this.properties.get(key);
        Preconditions.checkNotNull((Object)value, (String)"Value of key:%s is null", (Object)key);
        return value;
    }

    public ResourceType getType() {
        return this.type;
    }

    public static class Builder {
        private final String resourceId;
        private final String containerName;
        private final String groupName;
        private final ResourceType type;
        private int threadCount;
        private int memoryMb;
        private Map<String, String> properties = new HashMap<String, String>();

        public Builder(String containerName, String groupName, ResourceType type) {
            this.containerName = containerName;
            this.groupName = groupName;
            this.type = type;
            this.resourceId = this.generateShortUuid();
        }

        public Builder setThreadCount(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public Builder setMemoryMb(int memoryMb) {
            this.memoryMb = memoryMb;
            return this;
        }

        public Builder addProperties(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Resource build() {
            Preconditions.checkArgument((this.containerName != null && this.groupName != null && this.type != null ? 1 : 0) != 0, (Object)"containerName, groupName and type should not be null");
            return new Resource(this);
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        private String generateShortUuid() {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            BigInteger bigInteger = new BigInteger(uuid, 16);
            return bigInteger.toString(32);
        }
    }
}

