/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.api.metrics;

import java.util.List;
import java.util.Objects;
import org.apache.amoro.api.metrics.MetricType;
import org.apache.amoro.shade.guava32.com.google.common.base.Joiner;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;

public class MetricDefine {
    private final String name;
    private final List<String> tags;
    private final MetricType type;
    private final String description;

    MetricDefine(String name, List<String> tags, MetricType type, String description) {
        Preconditions.checkArgument((name != null && !name.trim().isEmpty() ? 1 : 0) != 0, (Object)"Metric name is required");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Metric type is required");
        this.name = name;
        if (tags == null) {
            tags = ImmutableList.of();
        }
        this.tags = tags;
        this.type = type;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public MetricType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDefine that = (MetricDefine)o;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append(",type=").append(this.type.name());
        builder.append("<");
        Joiner.on((String)",").appendTo(builder, this.tags.stream().sorted().iterator());
        builder.append(">");
        return builder.toString();
    }

    public static Builder defineCounter(String name) {
        return new Builder(name, MetricType.Counter);
    }

    public static Builder defineGauge(String name) {
        return new Builder(name, MetricType.Gauge);
    }

    public static class Builder {
        private final String name;
        private List<String> tags;
        private final MetricType type;
        private String description;

        Builder(String name, MetricType type) {
            this.name = name;
            this.type = type;
        }

        public Builder withTags(String ... tags) {
            this.tags = Lists.newArrayList((Object[])tags);
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public MetricDefine build() {
            return new MetricDefine(this.name, this.tags, this.type, this.description);
        }
    }
}

