/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.api.config;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.amoro.api.config.ConfigOption;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;

public class ConfigOptions {
    private ConfigOptions() {
    }

    public static OptionBuilder key(String key) {
        Preconditions.checkNotNull((Object)key);
        return new OptionBuilder(key);
    }

    public static class ListConfigOptionBuilder<E> {
        private final String key;
        private final Class<E> clazz;

        ListConfigOptionBuilder(String key, Class<E> clazz) {
            this.key = key;
            this.clazz = clazz;
        }

        @SafeVarargs
        public final ConfigOption<List<E>> defaultValues(E ... values) {
            return new ConfigOption<List<E>>(this.key, this.clazz, "", Arrays.asList(values), true);
        }

        public ConfigOption<List<E>> noDefaultValue() {
            return new ConfigOption<Object>(this.key, this.clazz, "", null, true);
        }
    }

    public static class TypedConfigOptionBuilder<T> {
        private final String key;
        private final Class<T> clazz;

        TypedConfigOptionBuilder(String key, Class<T> clazz) {
            this.key = key;
            this.clazz = clazz;
        }

        public ListConfigOptionBuilder<T> asList() {
            return new ListConfigOptionBuilder<T>(this.key, this.clazz);
        }

        public ConfigOption<T> defaultValue(T value) {
            return new ConfigOption<T>(this.key, this.clazz, "", value, false);
        }

        public ConfigOption<T> noDefaultValue() {
            return new ConfigOption<Object>(this.key, this.clazz, "", null, false);
        }
    }

    public static final class OptionBuilder {
        private static final Class<Map<String, String>> PROPERTIES_MAP_CLASS = Map.class;
        private final String key;

        OptionBuilder(String key) {
            this.key = key;
        }

        public TypedConfigOptionBuilder<Boolean> booleanType() {
            return new TypedConfigOptionBuilder<Boolean>(this.key, Boolean.class);
        }

        public TypedConfigOptionBuilder<Integer> intType() {
            return new TypedConfigOptionBuilder<Integer>(this.key, Integer.class);
        }

        public TypedConfigOptionBuilder<Long> longType() {
            return new TypedConfigOptionBuilder<Long>(this.key, Long.class);
        }

        public TypedConfigOptionBuilder<Float> floatType() {
            return new TypedConfigOptionBuilder<Float>(this.key, Float.class);
        }

        public TypedConfigOptionBuilder<Double> doubleType() {
            return new TypedConfigOptionBuilder<Double>(this.key, Double.class);
        }

        public TypedConfigOptionBuilder<String> stringType() {
            return new TypedConfigOptionBuilder<String>(this.key, String.class);
        }

        public TypedConfigOptionBuilder<Duration> durationType() {
            return new TypedConfigOptionBuilder<Duration>(this.key, Duration.class);
        }

        public <T extends Enum<T>> TypedConfigOptionBuilder<T> enumType(Class<T> enumClass) {
            return new TypedConfigOptionBuilder<T>(this.key, enumClass);
        }

        public TypedConfigOptionBuilder<Map<String, String>> mapType() {
            return new TypedConfigOptionBuilder<Map<String, String>>(this.key, PROPERTIES_MAP_CLASS);
        }

        @Deprecated
        public <T> ConfigOption<T> defaultValue(T value) {
            Preconditions.checkNotNull(value);
            return new ConfigOption<T>(this.key, value.getClass(), "", value, false);
        }

        @Deprecated
        public ConfigOption<String> noDefaultValue() {
            return new ConfigOption<Object>(this.key, String.class, "", null, false);
        }
    }
}

