/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.catalog;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.amoro.api.TableMeta;
import org.apache.amoro.hive.CachedHiveClientPool;
import org.apache.amoro.hive.table.KeyedHiveTable;
import org.apache.amoro.hive.table.UnkeyedHiveTable;
import org.apache.amoro.hive.utils.HiveSchemaUtil;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.AuthenticatedFileIOs;
import org.apache.amoro.io.AuthenticatedHadoopFileIO;
import org.apache.amoro.io.TableTrashManagers;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.Tables;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedHiveTables {
    private static final Logger LOG = LoggerFactory.getLogger(MixedHiveTables.class);
    protected Tables tables;
    protected TableMetaStore tableMetaStore;
    protected Map<String, String> catalogProperties;
    private volatile CachedHiveClientPool hiveClientPool;

    public MixedHiveTables(Map<String, String> catalogProperties, TableMetaStore metaStore) {
        this.tableMetaStore = metaStore;
        this.catalogProperties = catalogProperties;
        this.tables = new HadoopTables(this.tableMetaStore.getConfiguration());
        this.hiveClientPool = new CachedHiveClientPool(this.getTableMetaStore(), catalogProperties);
    }

    protected TableMetaStore getTableMetaStore() {
        return this.tableMetaStore;
    }

    public CachedHiveClientPool getHiveClientPool() {
        return this.hiveClientPool;
    }

    public Table loadHadoopTableByLocation(String location) {
        return (Table)this.tableMetaStore.doAs(() -> this.tables.load(location));
    }

    public MixedTable loadTableByMeta(TableMeta tableMeta) {
        if (tableMeta.getKeySpec() != null && tableMeta.getKeySpec().getFields() != null && tableMeta.getKeySpec().getFields().size() > 0) {
            return this.loadKeyedTable(tableMeta);
        }
        return this.loadUnKeyedTable(tableMeta);
    }

    protected KeyedHiveTable loadKeyedTable(TableMeta tableMeta) {
        TableIdentifier tableIdentifier = TableIdentifier.of((org.apache.amoro.api.TableIdentifier)tableMeta.getTableIdentifier());
        String tableLocation = this.checkLocation(tableMeta, "table");
        String baseLocation = this.checkLocation(tableMeta, "base");
        String changeLocation = this.checkLocation(tableMeta, "change");
        AuthenticatedHadoopFileIO fileIO = AuthenticatedFileIOs.buildRecoverableHadoopFileIO((TableIdentifier)tableIdentifier, (String)tableLocation, (Map)tableMeta.getProperties(), (TableMetaStore)this.tableMetaStore, this.catalogProperties);
        this.checkPrivilege((AuthenticatedFileIO)fileIO, baseLocation);
        Table baseIcebergTable = (Table)this.tableMetaStore.doAs(() -> this.tables.load(baseLocation));
        KeyedHiveTable.HiveBaseInternalTable baseTable = new KeyedHiveTable.HiveBaseInternalTable(tableIdentifier, MixedCatalogUtil.useMixedTableOperations((Table)baseIcebergTable, (String)baseLocation, (AuthenticatedFileIO)fileIO, (Configuration)this.tableMetaStore.getConfiguration()), fileIO, tableLocation, this.hiveClientPool, this.catalogProperties, false);
        Table changeIcebergTable = (Table)this.tableMetaStore.doAs(() -> this.tables.load(changeLocation));
        KeyedHiveTable.HiveChangeInternalTable changeTable = new KeyedHiveTable.HiveChangeInternalTable(tableIdentifier, MixedCatalogUtil.useMixedTableOperations((Table)changeIcebergTable, (String)changeLocation, (AuthenticatedFileIO)fileIO, (Configuration)this.tableMetaStore.getConfiguration()), (AuthenticatedFileIO)fileIO, this.catalogProperties);
        return new KeyedHiveTable(tableMeta, tableLocation, this.buildPrimaryKeySpec(baseTable.schema(), tableMeta), this.hiveClientPool, baseTable, changeTable);
    }

    private void checkPrivilege(AuthenticatedFileIO fileIO, String fileLocation) {
        if (!fileIO.exists(fileLocation)) {
            throw new NoSuchTableException("Table's base location %s does not exist ", new Object[]{fileLocation});
        }
    }

    protected UnkeyedHiveTable loadUnKeyedTable(TableMeta tableMeta) {
        TableIdentifier tableIdentifier = TableIdentifier.of((org.apache.amoro.api.TableIdentifier)tableMeta.getTableIdentifier());
        String baseLocation = this.checkLocation(tableMeta, "base");
        String tableLocation = this.checkLocation(tableMeta, "table");
        AuthenticatedHadoopFileIO fileIO = AuthenticatedFileIOs.buildRecoverableHadoopFileIO((TableIdentifier)tableIdentifier, (String)tableLocation, (Map)tableMeta.getProperties(), (TableMetaStore)this.tableMetaStore, this.catalogProperties);
        this.checkPrivilege((AuthenticatedFileIO)fileIO, baseLocation);
        Table table = (Table)this.tableMetaStore.doAs(() -> this.tables.load(baseLocation));
        return new UnkeyedHiveTable(tableIdentifier, MixedCatalogUtil.useMixedTableOperations((Table)table, (String)baseLocation, (AuthenticatedFileIO)fileIO, (Configuration)this.tableMetaStore.getConfiguration()), fileIO, tableLocation, this.hiveClientPool, this.catalogProperties);
    }

    protected KeyedTable createKeyedTable(TableMeta tableMeta, Schema schema, PrimaryKeySpec primaryKeySpec, PartitionSpec partitionSpec) {
        boolean allowExistedHiveTable = this.allowExistedHiveTable(tableMeta);
        TableIdentifier tableIdentifier = TableIdentifier.of((org.apache.amoro.api.TableIdentifier)tableMeta.getTableIdentifier());
        String baseLocation = this.checkLocation(tableMeta, "base");
        String changeLocation = this.checkLocation(tableMeta, "change");
        String tableLocation = this.checkLocation(tableMeta, "table");
        this.fillTableProperties(tableMeta);
        String hiveLocation = (String)tableMeta.getProperties().get("base.hive.location-root");
        if (!tableMeta.properties.containsKey("self-optimizing.full.trigger.interval")) {
            tableMeta.putToProperties("self-optimizing.full.trigger.interval", "86400000");
        }
        AuthenticatedHadoopFileIO fileIO = AuthenticatedFileIOs.buildRecoverableHadoopFileIO((TableIdentifier)tableIdentifier, (String)tableLocation, (Map)tableMeta.getProperties(), (TableMetaStore)this.tableMetaStore, this.catalogProperties);
        Table baseIcebergTable = (Table)this.tableMetaStore.doAs(() -> {
            try {
                Table createTable = this.tables.create(schema, partitionSpec, tableMeta.getProperties(), baseLocation);
                createTable.updateProperties().set("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)MappingUtil.create((Schema)createTable.schema()))).commit();
                return createTable;
            }
            catch (Exception e) {
                throw new IllegalStateException("create base table failed", e);
            }
        });
        KeyedHiveTable.HiveBaseInternalTable baseTable = new KeyedHiveTable.HiveBaseInternalTable(tableIdentifier, MixedCatalogUtil.useMixedTableOperations((Table)baseIcebergTable, (String)baseLocation, (AuthenticatedFileIO)fileIO, (Configuration)this.tableMetaStore.getConfiguration()), fileIO, tableLocation, this.hiveClientPool, this.catalogProperties, false);
        Table changeIcebergTable = (Table)this.tableMetaStore.doAs(() -> {
            try {
                Table createTable = this.tables.create(schema, partitionSpec, tableMeta.getProperties(), changeLocation);
                createTable.updateProperties().set("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)MappingUtil.create((Schema)createTable.schema()))).commit();
                return createTable;
            }
            catch (Exception e) {
                throw new IllegalStateException("create change table failed", e);
            }
        });
        KeyedHiveTable.HiveChangeInternalTable changeTable = new KeyedHiveTable.HiveChangeInternalTable(tableIdentifier, MixedCatalogUtil.useMixedTableOperations((Table)changeIcebergTable, (String)changeLocation, (AuthenticatedFileIO)fileIO, (Configuration)this.tableMetaStore.getConfiguration()), (AuthenticatedFileIO)fileIO, this.catalogProperties);
        Map metaProperties = tableMeta.getProperties();
        try {
            this.hiveClientPool.run(client -> {
                if (allowExistedHiveTable) {
                    org.apache.hadoop.hive.metastore.api.Table hiveTable = client.getTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName());
                    Map hiveParameters = hiveTable.getParameters();
                    hiveParameters.putAll(this.constructProperties(primaryKeySpec, tableMeta));
                    hiveTable.setParameters(hiveParameters);
                    client.alterTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName(), hiveTable);
                } else {
                    org.apache.hadoop.hive.metastore.api.Table hiveTable = this.newHiveTable(tableMeta, schema, partitionSpec);
                    hiveTable.setSd(HiveTableUtil.storageDescriptor(schema, partitionSpec, hiveLocation, FileFormat.valueOf((String)PropertyUtil.propertyAsString((Map)metaProperties, (String)"write.format.default", (String)"parquet").toUpperCase(Locale.ENGLISH))));
                    this.setProToHive(hiveTable, primaryKeySpec, tableMeta);
                    client.createTable(hiveTable);
                }
                return null;
            });
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to create hive table:" + tableMeta.getTableIdentifier(), e);
        }
        return new KeyedHiveTable(tableMeta, tableLocation, primaryKeySpec, this.hiveClientPool, baseTable, changeTable);
    }

    protected UnkeyedHiveTable createUnKeyedTable(TableMeta tableMeta, Schema schema, PrimaryKeySpec primaryKeySpec, PartitionSpec partitionSpec) {
        boolean allowExistedHiveTable = this.allowExistedHiveTable(tableMeta);
        TableIdentifier tableIdentifier = TableIdentifier.of((org.apache.amoro.api.TableIdentifier)tableMeta.getTableIdentifier());
        String baseLocation = this.checkLocation(tableMeta, "base");
        String tableLocation = this.checkLocation(tableMeta, "table");
        this.fillTableProperties(tableMeta);
        String hiveLocation = (String)tableMeta.getProperties().get("base.hive.location-root");
        Table table = (Table)this.tableMetaStore.doAs(() -> {
            try {
                Table createTable = this.tables.create(schema, partitionSpec, tableMeta.getProperties(), baseLocation);
                createTable.updateProperties().set("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)MappingUtil.create((Schema)createTable.schema()))).commit();
                return createTable;
            }
            catch (Exception e) {
                throw new IllegalStateException("create table failed", e);
            }
        });
        try {
            this.hiveClientPool.run(client -> {
                if (allowExistedHiveTable) {
                    org.apache.hadoop.hive.metastore.api.Table hiveTable = client.getTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName());
                    Map hiveParameters = hiveTable.getParameters();
                    hiveParameters.putAll(this.constructProperties(primaryKeySpec, tableMeta));
                    hiveTable.setParameters(hiveParameters);
                    client.alterTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName(), hiveTable);
                } else {
                    org.apache.hadoop.hive.metastore.api.Table hiveTable = this.newHiveTable(tableMeta, schema, partitionSpec);
                    hiveTable.setSd(HiveTableUtil.storageDescriptor(schema, partitionSpec, hiveLocation, FileFormat.valueOf((String)PropertyUtil.propertyAsString((Map)tableMeta.getProperties(), (String)"base.write.format", (String)"parquet").toUpperCase(Locale.ENGLISH))));
                    this.setProToHive(hiveTable, primaryKeySpec, tableMeta);
                    client.createTable(hiveTable);
                }
                return null;
            });
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to create hive table:" + tableMeta.getTableIdentifier(), e);
        }
        AuthenticatedHadoopFileIO fileIO = AuthenticatedFileIOs.buildRecoverableHadoopFileIO((TableIdentifier)tableIdentifier, (String)tableLocation, (Map)tableMeta.getProperties(), (TableMetaStore)this.tableMetaStore, this.catalogProperties);
        return new UnkeyedHiveTable(tableIdentifier, MixedCatalogUtil.useMixedTableOperations((Table)table, (String)baseLocation, (AuthenticatedFileIO)fileIO, (Configuration)this.tableMetaStore.getConfiguration()), fileIO, tableLocation, this.hiveClientPool, this.catalogProperties);
    }

    public void dropInternalTableByMeta(TableMeta tableMeta, boolean purge) {
        try {
            TableIdentifier tableId;
            String trashParentLocation;
            String customTrashLocation;
            AuthenticatedHadoopFileIO fileIO = AuthenticatedFileIOs.buildHadoopFileIO((TableMetaStore)this.tableMetaStore);
            HashMap tableProperties = Maps.newHashMap();
            try {
                MixedTable mixedTable = this.loadTableByMeta(tableMeta);
                tableProperties.putAll(mixedTable.properties());
            }
            catch (Exception loadException) {
                LOG.warn("load table failed when dropping table", (Throwable)loadException);
            }
            if (!purge) {
                String baseLocation = (String)tableMeta.getLocations().get("base");
                String changeLocation = (String)tableMeta.getLocations().get("change");
                try {
                    if (StringUtils.isNotBlank((CharSequence)baseLocation)) {
                        this.dropInternalTable(this.tableMetaStore, baseLocation, false);
                    }
                    if (StringUtils.isNotBlank((CharSequence)changeLocation)) {
                        this.dropInternalTable(this.tableMetaStore, changeLocation, false);
                    }
                }
                catch (Exception e) {
                    LOG.warn("drop base/change iceberg table fail ", (Throwable)e);
                }
            } else {
                String tableLocation = (String)tableMeta.getLocations().get("table");
                if (fileIO.exists(tableLocation)) {
                    LOG.info("try to delete table directory location is {}", (Object)tableLocation);
                    fileIO.asPrefixFileIO().deletePrefix(tableLocation);
                }
            }
            if ((customTrashLocation = (String)tableProperties.get("table-trash.custom-root-location")) != null && fileIO.exists(trashParentLocation = TableTrashManagers.getTrashParentLocation((TableIdentifier)(tableId = TableIdentifier.of((org.apache.amoro.api.TableIdentifier)tableMeta.getTableIdentifier())), (String)customTrashLocation))) {
                fileIO.asPrefixFileIO().deletePrefix(trashParentLocation);
            }
        }
        catch (Exception e) {
            LOG.warn("drop table directory fail ", (Throwable)e);
        }
    }

    private void dropInternalTable(TableMetaStore tableMetaStore, String internalTableLocation, boolean purge) {
        HadoopTables internalTables = new HadoopTables(tableMetaStore.getConfiguration());
        tableMetaStore.doAs(() -> {
            internalTables.dropTable(internalTableLocation, purge);
            return null;
        });
    }

    public void dropTableByMeta(TableMeta tableMeta, boolean purge) {
        this.dropInternalTableByMeta(tableMeta, purge);
        if (!HiveTableUtil.checkExist(this.hiveClientPool, TableIdentifier.of((org.apache.amoro.api.TableIdentifier)tableMeta.getTableIdentifier()))) {
            return;
        }
        if (purge) {
            try {
                this.hiveClientPool.run(client -> {
                    client.dropTable(tableMeta.getTableIdentifier().getDatabase(), tableMeta.getTableIdentifier().getTableName(), false, true);
                    return null;
                });
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException("Failed to drop table:" + tableMeta.getTableIdentifier(), e);
            }
        }
        try {
            this.hiveClientPool.run(client -> {
                org.apache.hadoop.hive.metastore.api.Table hiveTable = client.getTable(tableMeta.getTableIdentifier().getDatabase(), tableMeta.getTableIdentifier().getTableName());
                Map hiveParameters = hiveTable.getParameters();
                hiveParameters.remove("arctic.enabled");
                client.alterTable(tableMeta.getTableIdentifier().getDatabase(), tableMeta.tableIdentifier.getTableName(), hiveTable);
                return null;
            });
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to alter hive table while drop table meta:" + tableMeta.getTableIdentifier(), e);
        }
    }

    protected void fillTableProperties(TableMeta meta) {
        meta.putToProperties("table.create-timestamp", String.valueOf(System.currentTimeMillis()));
        meta.putToProperties("format-version", "2");
        meta.putToProperties("write.metadata.delete-after-commit.enabled", "true");
        meta.putToProperties("flink.max-continuous-empty-commits", String.valueOf(Integer.MAX_VALUE));
        String tableLocation = this.checkLocation(meta, "table");
        String hiveLocation = HiveTableUtil.hiveRootLocation(tableLocation);
        meta.putToProperties("base.hive.location-root", hiveLocation);
    }

    private Map<String, String> constructProperties(PrimaryKeySpec primaryKeySpec, TableMeta meta) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("arctic.enabled", "true");
        parameters.put("arctic.table.primary-keys", primaryKeySpec.description());
        parameters.put("arctic.table.root-location", (String)meta.getLocations().get("table"));
        return parameters;
    }

    private org.apache.hadoop.hive.metastore.api.Table newHiveTable(TableMeta meta, Schema schema, PartitionSpec partitionSpec) {
        long currentTimeMillis = System.currentTimeMillis();
        org.apache.hadoop.hive.metastore.api.Table newTable = new org.apache.hadoop.hive.metastore.api.Table(meta.getTableIdentifier().getTableName(), meta.getTableIdentifier().getDatabase(), meta.getProperties().getOrDefault("owner", System.getProperty("user.name")), (int)currentTimeMillis / 1000, (int)currentTimeMillis / 1000, Integer.MAX_VALUE, null, HiveSchemaUtil.hivePartitionFields(schema, partitionSpec), new HashMap(), null, null, TableType.EXTERNAL_TABLE.toString());
        newTable.getParameters().put("EXTERNAL", "TRUE");
        return newTable;
    }

    private void setProToHive(org.apache.hadoop.hive.metastore.api.Table hiveTable, PrimaryKeySpec primaryKeySpec, TableMeta meta) {
        Map<String, String> hiveTableProperties = this.constructProperties(primaryKeySpec, meta);
        HashMap parameters = Maps.newHashMap();
        parameters.putAll(hiveTable.getParameters());
        parameters.putAll(hiveTableProperties);
        hiveTable.setParameters((Map)parameters);
    }

    private boolean allowExistedHiveTable(TableMeta tableMeta) {
        String allowStringValue = (String)tableMeta.getProperties().remove("allow-hive-table-existed");
        return Boolean.parseBoolean(allowStringValue);
    }

    public MixedTable createTableByMeta(TableMeta tableMeta, Schema schema, PrimaryKeySpec primaryKeySpec, PartitionSpec partitionSpec) {
        if (primaryKeySpec.primaryKeyExisted()) {
            return this.createKeyedTable(tableMeta, schema, primaryKeySpec, partitionSpec);
        }
        return this.createUnKeyedTable(tableMeta, schema, primaryKeySpec, partitionSpec);
    }

    protected String checkLocation(TableMeta meta, String locationKey) {
        String location = (String)meta.getLocations().get(locationKey);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)location), (Object)"table location can't found");
        return location;
    }

    protected PrimaryKeySpec buildPrimaryKeySpec(Schema schema, TableMeta tableMeta) {
        PrimaryKeySpec.Builder builder = PrimaryKeySpec.builderFor((Schema)schema);
        if (tableMeta.getKeySpec() != null && tableMeta.getKeySpec().getFields() != null && !tableMeta.getKeySpec().getFields().isEmpty()) {
            for (String field : tableMeta.getKeySpec().getFields()) {
                builder.addColumn(field);
            }
        }
        return builder.build();
    }
}

