/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.management.cache.NoMatchingCachesException;
import org.apache.ignite.internal.management.cache.PartitionKeyV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.TransactionsHashRecord;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.jetbrains.annotations.Nullable;

public class IdleVerifyResultV2
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private Map<PartitionKeyV2, List<PartitionHashRecordV2>> cntrConflicts = new HashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
    @GridToStringInclude
    private Map<PartitionKeyV2, List<PartitionHashRecordV2>> hashConflicts = new HashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
    @GridToStringInclude
    private Map<PartitionKeyV2, List<PartitionHashRecordV2>> movingPartitions = new HashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
    @GridToStringInclude
    private Map<PartitionKeyV2, List<PartitionHashRecordV2>> lostPartitions = new HashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
    @GridToStringInclude
    @Nullable
    private List<List<TransactionsHashRecord>> txHashConflicts;
    @GridToStringInclude
    @Nullable
    private Map<ClusterNode, Collection<GridCacheVersion>> partiallyCommittedTxs;
    @GridToStringInclude
    private Map<ClusterNode, Exception> exceptions;

    public IdleVerifyResultV2() {
    }

    public IdleVerifyResultV2(Map<ClusterNode, Exception> exceptions) {
        this.exceptions = exceptions;
    }

    public IdleVerifyResultV2(Map<PartitionKeyV2, List<PartitionHashRecordV2>> clusterHashes, @Nullable List<List<TransactionsHashRecord>> txHashConflicts, @Nullable Map<ClusterNode, Collection<GridCacheVersion>> partiallyCommittedTxs) {
        this(clusterHashes, Collections.emptyMap());
        this.txHashConflicts = txHashConflicts;
        this.partiallyCommittedTxs = partiallyCommittedTxs;
    }

    public IdleVerifyResultV2(Map<PartitionKeyV2, List<PartitionHashRecordV2>> clusterHashes, Map<ClusterNode, Exception> exceptions) {
        for (Map.Entry<PartitionKeyV2, List<PartitionHashRecordV2>> e : clusterHashes.entrySet()) {
            Integer partHash = null;
            Integer partVerHash = null;
            Object updateCntr = null;
            for (PartitionHashRecordV2 record : e.getValue()) {
                if (record.partitionState() == PartitionHashRecordV2.PartitionState.MOVING) {
                    this.movingPartitions.computeIfAbsent(e.getKey(), k -> new ArrayList()).add(record);
                    continue;
                }
                if (record.partitionState() == PartitionHashRecordV2.PartitionState.LOST) {
                    this.lostPartitions.computeIfAbsent(e.getKey(), k -> new ArrayList()).add(record);
                    continue;
                }
                if (partHash == null) {
                    partHash = record.partitionHash();
                    partVerHash = record.partitionVersionsHash();
                    updateCntr = record.updateCounter();
                    continue;
                }
                if (!Objects.equals(record.updateCounter(), updateCntr)) {
                    this.cntrConflicts.putIfAbsent(e.getKey(), e.getValue());
                }
                if (record.partitionHash() == partHash.intValue() && record.partitionVersionsHash() == partVerHash.intValue()) continue;
                this.hashConflicts.putIfAbsent(e.getKey(), e.getValue());
            }
        }
        this.exceptions = exceptions;
    }

    @Override
    public byte getProtocolVersion() {
        return 4;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeMap(out, this.cntrConflicts);
        U.writeMap(out, this.hashConflicts);
        U.writeMap(out, this.movingPartitions);
        U.writeMap(out, this.exceptions);
        U.writeMap(out, this.lostPartitions);
        U.writeCollection(out, this.txHashConflicts);
        U.writeMap(out, this.partiallyCommittedTxs);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.cntrConflicts = U.readMap(in);
        this.hashConflicts = U.readMap(in);
        this.movingPartitions = U.readMap(in);
        if (protoVer >= 2) {
            this.exceptions = U.readMap(in);
        }
        if (protoVer >= 3) {
            this.lostPartitions = U.readMap(in);
        }
        if (protoVer >= 4) {
            this.txHashConflicts = (List)U.readCollection(in);
            this.partiallyCommittedTxs = U.readMap(in);
        }
    }

    public Map<PartitionKeyV2, List<PartitionHashRecordV2>> counterConflicts() {
        return this.cntrConflicts;
    }

    public Map<PartitionKeyV2, List<PartitionHashRecordV2>> hashConflicts() {
        return this.hashConflicts;
    }

    public Map<PartitionKeyV2, List<PartitionHashRecordV2>> movingPartitions() {
        return Collections.unmodifiableMap(this.movingPartitions);
    }

    public Map<PartitionKeyV2, List<PartitionHashRecordV2>> lostPartitions() {
        return this.lostPartitions;
    }

    public boolean hasConflicts() {
        return !F.isEmpty(this.hashConflicts()) || !F.isEmpty(this.counterConflicts()) || !F.isEmpty(this.txHashConflicts) || !F.isEmpty(this.partiallyCommittedTxs);
    }

    public Map<ClusterNode, Exception> exceptions() {
        return this.exceptions;
    }

    public void print(Consumer<String> printer, boolean printExceptionMessages) {
        int size;
        if (F.isEmpty(this.exceptions)) {
            if (!this.hasConflicts()) {
                printer.accept("The check procedure has finished, no conflicts have been found.\n");
            } else {
                this.printConflicts(printer);
            }
            Map<PartitionKeyV2, List<PartitionHashRecordV2>> moving = this.movingPartitions();
            if (!moving.isEmpty()) {
                printer.accept("Possible results are not full due to rebalance still in progress." + IgniteUtils.nl());
            }
            this.printSkippedPartitions(printer, moving, "MOVING");
            this.printSkippedPartitions(printer, this.lostPartitions(), "LOST");
            return;
        }
        printer.accept("The check procedure failed on " + size + " node" + ((size = this.exceptions.size()) == 1 ? "" : "s") + ".\n");
        if (!F.isEmpty(F.view(this.exceptions.values(), e -> e instanceof NoMatchingCachesException))) {
            printer.accept("\nThere are no caches matching given filter options.\n");
        }
        printer.accept("\nThe check procedure failed on nodes:\n");
        for (Map.Entry<ClusterNode, Exception> e2 : this.exceptions().entrySet()) {
            ClusterNode n = e2.getKey();
            printer.accept("\nNode ID: " + n.id() + " " + n.addresses() + "\nConsistent ID: " + n.consistentId() + "\n");
            if (!printExceptionMessages) continue;
            String msg = e2.getValue().getMessage();
            printer.accept("Exception: " + e2.getValue().getClass().getCanonicalName() + "\n");
            printer.accept((String)(msg == null ? "" : msg + "\n"));
        }
    }

    private void printSkippedPartitions(Consumer<String> printer, Map<PartitionKeyV2, List<PartitionHashRecordV2>> map, String partitionState) {
        if (!F.isEmpty(map)) {
            printer.accept("Verification was skipped for " + map.size() + " " + partitionState + " partitions:\n");
            for (Map.Entry<PartitionKeyV2, List<PartitionHashRecordV2>> entry : map.entrySet()) {
                printer.accept("Skipped partition: " + entry.getKey() + "\n");
                printer.accept("Partition instances: " + entry.getValue() + "\n");
            }
            printer.accept("\n");
        }
    }

    private void printConflicts(Consumer<String> printer) {
        int cntrConflictsSize = this.counterConflicts().size();
        int hashConflictsSize = this.hashConflicts().size();
        printer.accept("The check procedure has failed, conflict partitions has been found: [counterConflicts=" + cntrConflictsSize + ", hashConflicts=" + hashConflictsSize + (String)(this.txHashConflicts == null ? "" : ", txHashConflicts=" + this.txHashConflicts.size()) + (String)(this.partiallyCommittedTxs == null ? "" : ", partiallyCommittedSize=" + this.partiallyCommittedTxs.size()) + "]" + IgniteUtils.nl());
        HashSet<PartitionKeyV2> allConflicts = new HashSet<PartitionKeyV2>();
        if (!F.isEmpty(this.counterConflicts())) {
            allConflicts.addAll(this.counterConflicts().keySet());
            printer.accept("Update counter conflicts:" + IgniteUtils.nl());
            for (Map.Entry entry : this.counterConflicts().entrySet()) {
                printer.accept("Conflict partition: " + entry.getKey() + IgniteUtils.nl());
                printer.accept("Partition instances: " + entry.getValue() + IgniteUtils.nl());
            }
            printer.accept(IgniteUtils.nl());
        }
        if (!F.isEmpty(this.hashConflicts())) {
            allConflicts.addAll(this.hashConflicts().keySet());
            printer.accept("Hash conflicts:" + IgniteUtils.nl());
            for (Map.Entry entry : this.hashConflicts().entrySet()) {
                printer.accept("Conflict partition: " + entry.getKey() + IgniteUtils.nl());
                printer.accept("Partition instances: " + entry.getValue() + IgniteUtils.nl());
            }
        }
        if (!F.isEmpty(this.txHashConflicts)) {
            printer.accept("Transactions hashes conflicts:" + IgniteUtils.nl());
            for (List list : this.txHashConflicts) {
                printer.accept("Conflict nodes: " + list + IgniteUtils.nl());
            }
        }
        if (!F.isEmpty(this.partiallyCommittedTxs)) {
            printer.accept("Partially committed transactions:" + IgniteUtils.nl());
            for (Map.Entry entry : this.partiallyCommittedTxs.entrySet()) {
                printer.accept("Node: " + entry.getKey() + IgniteUtils.nl());
                printer.accept("Transactions: " + entry.getValue() + IgniteUtils.nl());
            }
        }
        printer.accept(IgniteUtils.nl());
        printer.accept("Total:" + IgniteUtils.nl());
        Map<String, TreeSet> conflictsSummary = allConflicts.stream().collect(Collectors.groupingBy(PartitionKeyV2::groupName, Collectors.mapping(PartitionKeyV2::partitionId, Collectors.toCollection(TreeSet::new))));
        for (Map.Entry<String, TreeSet> grpConflicts : conflictsSummary.entrySet()) {
            printer.accept(String.format("%s (%d)%s", grpConflicts.getKey(), grpConflicts.getValue().size(), IgniteUtils.nl()));
            String partsStr = grpConflicts.getValue().stream().map(String::valueOf).collect(Collectors.joining(","));
            printer.accept(partsStr + IgniteUtils.nl());
            printer.accept(IgniteUtils.nl());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdleVerifyResultV2 v2 = (IdleVerifyResultV2)o;
        return Objects.equals(this.cntrConflicts, v2.cntrConflicts) && Objects.equals(this.hashConflicts, v2.hashConflicts) && Objects.equals(this.movingPartitions, v2.movingPartitions) && Objects.equals(this.lostPartitions, v2.lostPartitions) && Objects.equals(this.exceptions, v2.exceptions) && Objects.equals(this.txHashConflicts, v2.txHashConflicts) && Objects.equals(this.partiallyCommittedTxs, v2.partiallyCommittedTxs);
    }

    public int hashCode() {
        return Objects.hash(this.cntrConflicts, this.hashConflicts, this.movingPartitions, this.lostPartitions, this.exceptions, this.txHashConflicts, this.partiallyCommittedTxs);
    }

    public String toString() {
        return S.toString(IdleVerifyResultV2.class, this);
    }
}

