/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.BitSet;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;

public final class IgniteFeatures
extends Enum<IgniteFeatures> {
    public static final /* enum */ IgniteFeatures PME_FREE_SWITCH = new IgniteFeatures(19);
    private final int featureId;
    private static final /* synthetic */ IgniteFeatures[] $VALUES;

    public static IgniteFeatures[] values() {
        return (IgniteFeatures[])$VALUES.clone();
    }

    public static IgniteFeatures valueOf(String name) {
        return Enum.valueOf(IgniteFeatures.class, name);
    }

    private IgniteFeatures(int featureId) {
        this.featureId = featureId;
    }

    public int getFeatureId() {
        return this.featureId;
    }

    public static boolean nodeSupports(ClusterNode clusterNode, IgniteFeatures feature) {
        byte[] features = (byte[])clusterNode.attribute("org.apache.ignite.features");
        if (features == null) {
            return false;
        }
        return IgniteFeatures.nodeSupports(features, feature);
    }

    public static boolean nodeSupports(byte[] featuresAttrBytes, IgniteFeatures feature) {
        int featureId = feature.getFeatureId();
        int byteIdx = featureId >>> 3;
        if (byteIdx >= featuresAttrBytes.length) {
            return false;
        }
        int bitIdx = featureId & 7;
        return (featuresAttrBytes[byteIdx] & 1 << bitIdx) != 0;
    }

    public static boolean allNodesSupports(Iterable<ClusterNode> nodes, IgniteFeatures feature) {
        for (ClusterNode next : nodes) {
            if (IgniteFeatures.nodeSupports(next, feature)) continue;
            return false;
        }
        return true;
    }

    public static boolean allNodesSupport(DiscoverySpi discoSpi, IgniteFeatures feature) {
        if (discoSpi instanceof IgniteDiscoverySpi) {
            return ((IgniteDiscoverySpi)discoSpi).allNodesSupport(feature);
        }
        return IgniteFeatures.allNodesSupports(discoSpi.getRemoteNodes(), feature);
    }

    public static byte[] allFeatures() {
        BitSet set = new BitSet();
        for (IgniteFeatures val : IgniteFeatures.values()) {
            if (val == PME_FREE_SWITCH && IgniteSystemProperties.getBoolean("IGNITE_PME_FREE_SWITCH_DISABLED")) continue;
            int featureId = val.getFeatureId();
            assert (!set.get(featureId)) : "Duplicate feature ID found for [" + val + "] having same ID [" + featureId + "]";
            set.set(featureId);
        }
        return set.toByteArray();
    }

    static {
        $VALUES = new IgniteFeatures[]{PME_FREE_SWITCH};
    }
}

