/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite3.internal.sql.engine.rel.AbstractIndexScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite3.internal.sql.engine.rel.SourceAwareIgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite3.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteIndexScan
extends AbstractIndexScan
implements SourceAwareIgniteRel {
    private static final String REL_TYPE_NAME = "IndexScan";
    private final long sourceId;
    private final RelCollation collation;

    public IgniteIndexScan(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
        this.collation = input.getCollation();
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
    }

    public IgniteIndexScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, String idxName, IgniteIndex.Type type, RelCollation collation, @Nullable List<String> names, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable List<SearchBounds> searchBounds, @Nullable ImmutableIntList requiredCols) {
        this(-1L, cluster, traits, tbl, idxName, type, collation, names, proj, cond, searchBounds, requiredCols);
    }

    private IgniteIndexScan(long sourceId, RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, String idxName, IgniteIndex.Type type, RelCollation collation, @Nullable List<String> names, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable List<SearchBounds> searchBounds, @Nullable ImmutableIntList requiredCols) {
        super(cluster, traits, List.of(), tbl, idxName, type, names, proj, cond, searchBounds, requiredCols);
        this.sourceId = sourceId;
        this.collation = collation;
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    @Override
    public RelCollation collation() {
        return this.collation;
    }

    @Override
    protected RelWriter explainTerms0(RelWriter pw) {
        return super.explainTerms0(pw).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L).itemIf("collation", (Object)this.collation(), this.type == IgniteIndex.Type.SORTED);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteIndexScan(sourceId, this.getCluster(), this.getTraitSet(), this.getTable(), this.idxName, this.type, this.collation, this.names, this.projects, this.condition, this.searchBounds, this.requiredColumns);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteIndexScan(this.sourceId, cluster, this.getTraitSet(), this.getTable(), this.idxName, this.type, this.collation, this.names, this.projects, this.condition, this.searchBounds, this.requiredColumns);
    }

    @Override
    protected IgniteIndexScan copy(@Nullable List<RexNode> newProjects, @Nullable RexNode newCondition, @Nullable List<SearchBounds> newSearchBounds) {
        return new IgniteIndexScan(this.sourceId, this.getCluster(), this.getTraitSet(), this.getTable(), this.idxName, this.type, this.collation, this.names, newProjects, newCondition, newSearchBounds, this.requiredColumns);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        this.explainAttributes(writer);
        if (this.type == IgniteIndex.Type.SORTED) {
            writer.addCollation(this.collation, this.getRowType());
        }
        return writer;
    }
}

