/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.TestOnly;

public class IgniteSpinReadWriteLock {
    private static final long NO_OWNER = -1L;
    private static final int WRITE_LOCKED = -1;
    private static final int AVAILABLE = 0;
    private static final int SLEEP_MILLIS = 10;
    private static final VarHandle PENDING_WLOCKS_VH;
    private static final VarHandle STATE_VH;
    private final ThreadLocal<Integer> readLockEntryCnt = ThreadLocal.withInitial(() -> 0);
    private volatile int state;
    private volatile int pendingWriteLocks;
    private long writeLockOwner = -1L;
    private int writeLockEntryCnt;

    public void readLock() {
        int cnt = this.readLockEntryCnt.get();
        if (this.alreadyHoldingAnyLock(cnt)) {
            this.incrementCurrentThreadReadLockCount(cnt);
            return;
        }
        boolean interrupted = false;
        while (true) {
            int curState = this.state;
            assert (curState >= -1);
            if (this.writeLockedOrGoingToBe(curState)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
                continue;
            }
            if (this.tryAdvanceStateToReadLocked(curState)) break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.readLockEntryCnt.set(1);
    }

    private boolean alreadyHoldingAnyLock(int currentThreadReadLockAcquiredCount) {
        return currentThreadReadLockAcquiredCount > 0 || this.writeLockedByCurrentThread();
    }

    private void incrementCurrentThreadReadLockCount(int cnt) {
        assert (this.state > 0 || this.state == -1);
        this.readLockEntryCnt.set(cnt + 1);
    }

    private boolean writeLockedOrGoingToBe(int curState) {
        return curState == -1 || this.pendingWriteLocks > 0;
    }

    private boolean tryAdvanceStateToReadLocked(int curState) {
        return STATE_VH.compareAndSet(this, curState, curState + 1);
    }

    public boolean tryReadLock() {
        int curState;
        int cnt = this.readLockEntryCnt.get();
        if (this.alreadyHoldingAnyLock(cnt)) {
            this.incrementCurrentThreadReadLockCount(cnt);
            return true;
        }
        do {
            if (!this.writeLockedOrGoingToBe(curState = this.state)) continue;
            return false;
        } while (!this.tryAdvanceStateToReadLocked(curState));
        this.readLockEntryCnt.set(1);
        return true;
    }

    public void readUnlock() {
        int curState;
        int cnt = this.readLockEntryCnt.get();
        if (cnt == 0) {
            throw new IllegalMonitorStateException();
        }
        if (cnt > 1 || this.writeLockedByCurrentThread()) {
            assert (this.state > 0 || this.state == -1);
            this.readLockEntryCnt.set(cnt - 1);
            return;
        }
        do {
            curState = this.state;
            assert (curState > 0);
        } while (!STATE_VH.compareAndSet(this, curState, curState - 1));
        this.readLockEntryCnt.set(0);
    }

    public void writeLock() {
        if (this.writeLockedByCurrentThread()) {
            this.incrementWriteLockCount();
            return;
        }
        boolean interrupted = false;
        this.incrementPendingWriteLocks();
        try {
            while (!this.trySwitchStateToWriteLocked()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
            }
        }
        finally {
            this.decrementPendingWriteLocks();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.finishWriteLockAcquire();
    }

    private void incrementWriteLockCount() {
        assert (this.state == -1);
        ++this.writeLockEntryCnt;
    }

    private void incrementPendingWriteLocks() {
        int curPendingWriteLocks;
        while (!PENDING_WLOCKS_VH.compareAndSet(this, curPendingWriteLocks = this.pendingWriteLocks, curPendingWriteLocks + 1)) {
        }
    }

    private boolean trySwitchStateToWriteLocked() {
        return STATE_VH.compareAndSet(this, 0, -1);
    }

    private void decrementPendingWriteLocks() {
        int curPendingWriteLocks;
        do {
            curPendingWriteLocks = this.pendingWriteLocks;
            assert (curPendingWriteLocks > 0);
        } while (!PENDING_WLOCKS_VH.compareAndSet(this, curPendingWriteLocks, curPendingWriteLocks - 1));
    }

    private void finishWriteLockAcquire() {
        assert (this.writeLockOwner == -1L);
        this.writeLockOwner = Thread.currentThread().getId();
        this.writeLockEntryCnt = 1;
    }

    public void writeLockBusy() {
        if (this.writeLockedByCurrentThread()) {
            this.incrementWriteLockCount();
            return;
        }
        this.incrementPendingWriteLocks();
        try {
            while (!this.trySwitchStateToWriteLocked()) {
            }
        }
        finally {
            this.decrementPendingWriteLocks();
        }
        this.finishWriteLockAcquire();
    }

    public boolean writeLockedByCurrentThread() {
        return this.writeLockOwner == Thread.currentThread().getId();
    }

    public boolean tryWriteLock() {
        if (this.writeLockedByCurrentThread()) {
            this.incrementWriteLockCount();
            return true;
        }
        if (this.trySwitchStateToWriteLocked()) {
            this.finishWriteLockAcquire();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryWriteLock(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.writeLockedByCurrentThread()) {
            this.incrementWriteLockCount();
            return true;
        }
        this.incrementPendingWriteLocks();
        try {
            long startNanos = System.nanoTime();
            long timeoutNanos = unit.toNanos(timeout);
            do {
                if (this.trySwitchStateToWriteLocked()) {
                    this.finishWriteLockAcquire();
                    boolean bl = true;
                    return bl;
                }
                Thread.sleep(10L);
            } while (System.nanoTime() - startNanos < timeoutNanos);
            boolean bl = false;
            return bl;
        }
        finally {
            this.decrementPendingWriteLocks();
        }
    }

    public void writeUnlock() {
        if (!this.writeLockedByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (this.writeLockEntryCnt > 1) {
            --this.writeLockEntryCnt;
            return;
        }
        this.writeLockEntryCnt = 0;
        this.writeLockOwner = -1L;
        int update = this.readLockEntryCnt.get() > 0 ? 1 : 0;
        boolean b = STATE_VH.compareAndSet(this, -1, update);
        assert (b);
    }

    @TestOnly
    int pendingWriteLocksCount() {
        return this.pendingWriteLocks;
    }

    public String toString() {
        return S.toString(IgniteSpinReadWriteLock.class, this);
    }

    static {
        try {
            STATE_VH = MethodHandles.lookup().findVarHandle(IgniteSpinReadWriteLock.class, "state", Integer.TYPE);
            PENDING_WLOCKS_VH = MethodHandles.lookup().findVarHandle(IgniteSpinReadWriteLock.class, "pendingWriteLocks", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

