/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.node.status;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.node.status.NodeStatus;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.NodeManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.NodeState;

@Singleton
public class NodeStatusCall
implements Call<UrlCallInput, NodeStatus> {
    private final ApiClientFactory clientFactory;

    public NodeStatusCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<NodeStatus> execute(UrlCallInput input) {
        String clusterUrl = input.getUrl();
        try {
            NodeState nodeState = this.fetchNodeState(clusterUrl);
            return DefaultCallOutput.success(NodeStatus.builder().name(nodeState.getName()).state(nodeState.getState().getValue()).build());
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }

    private NodeState fetchNodeState(String url) throws ApiException {
        return new NodeManagementApi(this.clientFactory.getClient(url)).nodeState();
    }
}

