/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.metrics;

import java.util.List;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.AtomicIntMetric;
import org.apache.ignite.internal.metrics.LongAdderMetric;
import org.apache.ignite.internal.metrics.Metric;

public class ResourceVacuumMetrics
extends AbstractMetricSource<Holder> {
    public static final String SOURCE_NAME = "resource.vacuum";

    public ResourceVacuumMetrics() {
        super(SOURCE_NAME, "Resource vacuum metrics.");
    }

    protected Holder createHolder() {
        return new Holder();
    }

    public void onVolatileStateVacuum() {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.vacuumizedVolatileTxnMetaCount.increment();
        }
    }

    public void onMarkedForVacuum() {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.markedForVacuumTransactionMetaCount.increment();
        }
    }

    public void onVacuumFinish(int persistentStatesVacuumizedCount, int skippedForFurtherProcessingUnfinishedTxnsCount) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.vacuumizedPersistentTxnMetaCount.add((long)persistentStatesVacuumizedCount);
            holder.skippedForFurtherProcessingUnfinishedTxnsCount.value(skippedForFurtherProcessingUnfinishedTxnsCount);
        }
    }

    protected static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final LongAdderMetric vacuumizedVolatileTxnMetaCount = new LongAdderMetric("VacuumizedVolatileTxnMetaCount", "Count of volatile transaction metas that have been vacuumized.");
        private final LongAdderMetric vacuumizedPersistentTxnMetaCount = new LongAdderMetric("VacuumizedPersistentTransactionMetaCount", "Count of persistent transaction metas that have been vacuumized.");
        private final LongAdderMetric markedForVacuumTransactionMetaCount = new LongAdderMetric("MarkedForVacuumTransactionMetaCount", "Count of transaction metas that have been marked for vacuum.");
        private final AtomicIntMetric skippedForFurtherProcessingUnfinishedTxnsCount = new AtomicIntMetric("SkippedForFurtherProcessingUnfinishedTransactionCount", "The current number of unfinished transactions that are skipped by vacuumizer for further processing.");
        private final List<Metric> metrics = List.of(this.vacuumizedVolatileTxnMetaCount, this.vacuumizedPersistentTxnMetaCount, this.markedForVacuumTransactionMetaCount, this.skippedForFurtherProcessingUnfinishedTxnsCount);

        protected Holder() {
        }

        public Iterable<Metric> metrics() {
            return this.metrics;
        }
    }
}

