/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.ignite.internal.sql.engine.rel.IgniteExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteLimit;
import org.apache.ignite.internal.sql.engine.rel.IgniteSort;
import org.apache.ignite.internal.sql.engine.rule.ImmutableSortExchangeTransposeRule;
import org.apache.ignite.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;

@Value.Enclosing
public class SortExchangeTransposeRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.INSTANCE.toRule();

    private SortExchangeTransposeRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public boolean matches(RelOptRuleCall call) {
        IgniteExchange exchange = (IgniteExchange)call.rel(1);
        return SortExchangeTransposeRule.hashAlike(TraitUtils.distribution(exchange.getInput())) && exchange.distribution() == IgniteDistributions.single();
    }

    private static boolean hashAlike(IgniteDistribution distribution) {
        return distribution.getType() == RelDistribution.Type.HASH_DISTRIBUTED || distribution.getType() == RelDistribution.Type.RANDOM_DISTRIBUTED;
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteSort sort = (IgniteSort)call.rel(0);
        IgniteExchange exchange = (IgniteExchange)call.rel(1);
        RelOptCluster cluster = sort.getCluster();
        RelCollation collation = sort.collation();
        RelNode input = exchange.getInput();
        IgniteSort newSort = new IgniteSort(cluster, input.getTraitSet().replace((RelTrait)sort.getCollation()), input, sort.getCollation(), null, SortExchangeTransposeRule.createLimitForSort(cluster.getPlanner().getExecutor(), cluster.getRexBuilder(), sort.offset, sort.fetch));
        if (sort.offset != null || sort.fetch != null) {
            call.transformTo((RelNode)new IgniteLimit(cluster, exchange.getTraitSet().replace((RelTrait)collation), SortExchangeTransposeRule.convert((RelNode)newSort, (RelTraitSet)exchange.getTraitSet().replace((RelTrait)collation)), sort.offset, sort.fetch));
        } else {
            call.transformTo((RelNode)new IgniteExchange(cluster, exchange.getTraitSet().replace((RelTrait)collation), (RelNode)newSort, exchange.distribution()), Map.of(newSort, sort));
        }
    }

    @Nullable
    private static RexNode createLimitForSort(@Nullable RexExecutor executor, RexBuilder builder, @Nullable RexNode offset, @Nullable RexNode fetch) {
        block7: {
            if (fetch == null) {
                return null;
            }
            if (offset != null) {
                boolean shouldTryToSimplify = RexUtil.isLiteral((RexNode)fetch, (boolean)false) && RexUtil.isLiteral((RexNode)offset, (boolean)false);
                fetch = builder.makeCall((SqlOperator)IgniteSqlOperatorTable.PLUS, new RexNode[]{fetch, offset});
                if (shouldTryToSimplify && executor != null) {
                    try {
                        ArrayList result = new ArrayList();
                        executor.reduce(builder, List.of(fetch), result);
                        assert (result.size() <= 1) : result;
                        if (result.size() == 1) {
                            fetch = (RexNode)result.get(0);
                        }
                    }
                    catch (Exception ex) {
                        if (!IgniteUtils.assertionsEnabled()) break block7;
                        ExceptionUtils.sneakyThrow((Throwable)ex);
                    }
                }
            }
        }
        return fetch;
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config INSTANCE = (Config)ImmutableSortExchangeTransposeRule.Config.of().withDescription("SortExchangeTransposeRule").withOperandSupplier(o0 -> o0.operand(IgniteSort.class).oneInput(o1 -> o1.operand(IgniteExchange.class).anyInputs())).as(Config.class);

        default public SortExchangeTransposeRule toRule() {
            return new SortExchangeTransposeRule(this);
        }
    }
}

