/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.sql.engine.rel.SourceAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteSystemViewScan
extends ProjectableFilterableTableScan
implements SourceAwareIgniteRel {
    private static final String REL_TYPE_NAME = "SystemViewScan";
    private final long sourceId;

    public IgniteSystemViewScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, @Nullable List<String> names, @Nullable List<RexNode> projections, @Nullable RexNode condition, @Nullable ImmutableIntList reqColumns) {
        this(-1L, cluster, traitSet, hints, table, names, projections, condition, reqColumns);
    }

    public IgniteSystemViewScan(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
    }

    private IgniteSystemViewScan(long sourceId, RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, @Nullable List<String> names, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableIntList reqColumns) {
        super(cluster, traitSet, hints, table, names, proj, cond, reqColumns);
        this.sourceId = sourceId;
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteSystemViewScan(sourceId, this.getCluster(), this.getTraitSet(), (List<RelHint>)this.getHints(), this.getTable(), this.names, this.projects, this.condition, this.requiredColumns);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteSystemViewScan(this.sourceId, cluster, this.getTraitSet(), (List<RelHint>)this.getHints(), this.getTable(), this.names, this.projects, this.condition, this.requiredColumns);
    }

    @Override
    protected ProjectableFilterableTableScan copy(@Nullable List<RexNode> newProjects, @Nullable RexNode newCondition) {
        return new IgniteSystemViewScan(this.sourceId, this.getCluster(), this.getTraitSet(), (List<RelHint>)this.getHints(), this.getTable(), this.names, newProjects, newCondition, this.requiredColumns);
    }

    public IgniteSystemViewScan withHints(List<RelHint> hintList) {
        return new IgniteSystemViewScan(this.sourceId, this.getCluster(), this.getTraitSet(), hintList, this.getTable(), this.names, this.projects, this.condition, this.requiredColumns);
    }

    @Override
    protected RelWriter explainTerms0(RelWriter pw) {
        return super.explainTerms0(pw).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        return this.explainAttributes(writer);
    }
}

