/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.direct;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.network.direct.state.DirectMessageState;
import org.apache.ignite.internal.network.direct.state.DirectMessageStateItem;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStream;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStreamImplV1;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.jetbrains.annotations.Nullable;

public class DirectMessageReader
implements MessageReader {
    private final DirectMessageState<StateItem> state = new DirectMessageState<StateItem>(StateItem.class, () -> new StateItem(serializationService, protoVer));
    private boolean lastRead;

    public DirectMessageReader(PerSessionSerializationService serializationService, byte protoVer) {
    }

    public void setBuffer(ByteBuffer buf) {
        this.state.item().stream.setBuffer(buf);
    }

    public void setCurrentReadClass(Class<? extends NetworkMessage> msgCls) {
    }

    public boolean beforeMessageRead() {
        return true;
    }

    public boolean afterMessageRead(Class<? extends NetworkMessage> msgCls) {
        return true;
    }

    public byte readByte(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        byte val = stream.readByte();
        this.lastRead = stream.lastFinished();
        return val;
    }

    public short readShort(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        short val = stream.readShort();
        this.lastRead = stream.lastFinished();
        return val;
    }

    public int readInt(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        int val = stream.readInt();
        this.lastRead = stream.lastFinished();
        return val;
    }

    public int readInt(String name, int dflt) {
        return this.readInt(name);
    }

    public long readLong(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        long val = stream.readLong();
        this.lastRead = stream.lastFinished();
        return val;
    }

    public float readFloat(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        float val = stream.readFloat();
        this.lastRead = stream.lastFinished();
        return val;
    }

    public double readDouble(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        double val = stream.readDouble();
        this.lastRead = stream.lastFinished();
        return val;
    }

    public char readChar(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        char val = stream.readChar();
        this.lastRead = stream.lastFinished();
        return val;
    }

    public boolean readBoolean(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        boolean val = stream.readBoolean();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Nullable
    public byte[] readByteArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        byte[] arr = stream.readByteArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Nullable
    public short[] readShortArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        short[] arr = stream.readShortArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Nullable
    public int[] readIntArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        int[] arr = stream.readIntArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Nullable
    public long[] readLongArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        long[] arr = stream.readLongArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Nullable
    public float[] readFloatArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        float[] arr = stream.readFloatArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Nullable
    public double[] readDoubleArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        double[] arr = stream.readDoubleArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Nullable
    public char[] readCharArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        char[] arr = stream.readCharArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Nullable
    public boolean[] readBooleanArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        boolean[] arr = stream.readBooleanArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    public String readString(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        String val = stream.readString();
        this.lastRead = stream.lastFinished();
        return val;
    }

    public BitSet readBitSet(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        BitSet val = stream.readBitSet();
        this.lastRead = stream.lastFinished();
        return val;
    }

    public ByteBuffer readByteBuffer(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        ByteBuffer val = stream.readByteBuffer();
        this.lastRead = stream.lastFinished();
        return val;
    }

    public UUID readUuid(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        UUID val = stream.readUuid();
        this.lastRead = stream.lastFinished();
        return val;
    }

    public IgniteUuid readIgniteUuid(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        IgniteUuid val = stream.readIgniteUuid();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Nullable
    public <T extends NetworkMessage> T readMessage(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        Object msg = stream.readMessage(this);
        this.lastRead = stream.lastFinished();
        return msg;
    }

    public <T> T[] readObjectArray(String name, MessageCollectionItemType itemType, Class<T> itemCls) {
        DirectByteBufferStream stream = this.state.item().stream;
        T[] msg = stream.readObjectArray(itemType, itemCls, this);
        this.lastRead = stream.lastFinished();
        return msg;
    }

    public <C extends Collection<?>> C readCollection(String name, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.state.item().stream;
        Object col = stream.readCollection(itemType, this);
        this.lastRead = stream.lastFinished();
        return col;
    }

    public <C extends List<?>> C readList(String name, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.state.item().stream;
        Object col = stream.readCollection(itemType, this);
        this.lastRead = stream.lastFinished();
        assert (col == null || col instanceof List) : col;
        return (C)((List)col);
    }

    public <C extends Set<?>> C readSet(String name, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.state.item().stream;
        Object col = stream.readSet(itemType, this);
        this.lastRead = stream.lastFinished();
        return col;
    }

    public <M extends Map<?, ?>> M readMap(String name, MessageCollectionItemType keyType, MessageCollectionItemType valType, boolean linked) {
        DirectByteBufferStream stream = this.state.item().stream;
        Object map = stream.readMap(keyType, valType, linked, this);
        this.lastRead = stream.lastFinished();
        return map;
    }

    public boolean isLastRead() {
        return this.lastRead;
    }

    public int state() {
        return this.state.item().state;
    }

    public void incrementState() {
        ++this.state.item().state;
    }

    public void beforeInnerMessageRead() {
        this.state.forward();
    }

    public void afterInnerMessageRead(boolean finished) {
        this.state.backward(finished);
    }

    public void reset() {
        this.state.reset();
    }

    private static class StateItem
    implements DirectMessageStateItem {
        private final DirectByteBufferStream stream;
        private int state;

        StateItem(PerSessionSerializationService serializationService, byte protoVer) {
            switch (protoVer) {
                case 1: {
                    this.stream = new DirectByteBufferStreamImplV1(serializationService);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid protocol version: " + protoVer);
                }
            }
        }

        @Override
        public void reset() {
            this.state = 0;
        }
    }
}

