/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.client;

import java.io.Serializable;
import java.util.Objects;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.network.NetworkAddress;

public final class Peer
implements Serializable {
    private final NetworkAddress addr;
    private final int priority;

    public Peer(Peer peer) {
        this.addr = peer.address();
        this.priority = peer.getPriority();
    }

    public Peer(NetworkAddress addr) {
        this(addr, -1);
    }

    public Peer(NetworkAddress addr, int priority) {
        this.addr = addr;
        this.priority = priority;
    }

    public NetworkAddress address() {
        return this.addr;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Peer peer = (Peer)o;
        return this.priority == peer.priority && this.addr.equals((Object)peer.addr);
    }

    public int hashCode() {
        return Objects.hash(this.addr, this.priority);
    }

    public String toString() {
        return S.toString(Peer.class, (Object)this);
    }
}

