/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.externalize.RelInputEx;
import org.apache.ignite.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIndexScan
extends ProjectableFilterableTableScan {
    protected final String idxName;
    protected final List<SearchBounds> searchBounds;
    protected final IgniteIndex.Type type;

    protected AbstractIndexScan(RelInput input) {
        super(input);
        this.idxName = input.getString("index");
        this.type = (IgniteIndex.Type)input.getEnum("type", IgniteIndex.Type.class);
        this.searchBounds = ((RelInputEx)input).getSearchBounds("searchBounds");
    }

    protected AbstractIndexScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, String idxName, IgniteIndex.Type type, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable List<SearchBounds> searchBounds, @Nullable ImmutableBitSet reqColumns) {
        super(cluster, traitSet, hints, table, proj, cond, reqColumns);
        this.idxName = idxName;
        this.type = type;
        this.searchBounds = searchBounds;
    }

    @Override
    protected RelWriter explainTerms0(RelWriter pw) {
        pw = pw.item("index", (Object)this.idxName).item("type", (Object)this.type.name()).itemIf("searchBounds", this.searchBounds, this.searchBounds != null);
        return super.explainTerms0(pw);
    }

    public String indexName() {
        return this.idxName;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double cost;
        double rows = this.table.getRowCount();
        if (this.condition == null) {
            cost = rows * 1.0;
        } else {
            RexBuilder builder = this.getCluster().getRexBuilder();
            double selectivity = 1.0;
            cost = 0.0;
            if (this.searchBounds != null) {
                selectivity = mq.getSelectivity((RelNode)this, RexUtil.composeConjunction((RexBuilder)builder, Commons.transform(this.searchBounds, b -> b == null ? null : b.condition())));
                cost = Math.log(rows) * 3.0;
            }
            if ((rows *= selectivity) <= 0.0) {
                rows = 1.0;
            }
            cost += rows * 4.0;
        }
        return planner.getCostFactory().makeCost(rows, cost, 0.0).plus(planner.getCostFactory().makeTinyCost());
    }

    public List<SearchBounds> searchBounds() {
        return this.searchBounds;
    }
}

