/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import org.apache.ignite.internal.sql.engine.message.QueryBatchMessage;
import org.apache.ignite.internal.sql.engine.message.QueryBatchMessageImpl;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageSerializer;
import org.apache.ignite.network.serialization.MessageWriter;

class QueryBatchMessageSerializer
implements MessageSerializer<QueryBatchMessage> {
    QueryBatchMessageSerializer() {
    }

    public boolean writeMessage(QueryBatchMessage msg, MessageWriter writer) throws MessageMappingException {
        QueryBatchMessageImpl message = (QueryBatchMessageImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)6)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("batchId", message.batchId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeLong("exchangeId", message.exchangeId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeLong("fragmentId", message.fragmentId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeBoolean("last", message.last());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeUuid("queryId", message.queryId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeByteArray("rowsByteArray", message.rowsByteArray());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

