/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;
import org.apache.ignite.internal.sql.engine.schema.ModifyRow;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;

public class ModifyNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private static final IgniteLogger LOG = Loggers.forClass(ModifyNode.class);
    private final InternalIgniteTable table;
    private final TableModify.Operation modifyOp;
    private final List<String> cols;
    private final InternalTable tableView;
    private List<ModifyRow> rows = new ArrayList<ModifyRow>(100);
    private long updatedRows;
    private int waiting;
    private int requested;
    private boolean inLoop;
    private State state = State.UPDATING;
    private InternalTransaction tx;

    public ModifyNode(ExecutionContext<RowT> ctx, RelDataType rowType, InternalIgniteTable table, TableModify.Operation op, List<String> cols) {
        super(ctx, rowType);
        this.table = table;
        this.modifyOp = op;
        this.cols = cols;
        this.tx = ctx.transaction();
        this.tableView = table.table();
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.tryEnd();
        }
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        assert (this.state == State.UPDATING);
        this.checkState();
        --this.waiting;
        switch (this.modifyOp) {
            case DELETE: 
            case UPDATE: 
            case INSERT: 
            case MERGE: {
                this.rows.add(this.table.toModifyRow(this.context(), row, this.modifyOp, this.cols));
                this.flushTuples(false);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.modifyOp.name());
            }
        }
        if (this.waiting == 0) {
            this.waiting = 100;
            this.source().request(100);
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        this.state = State.UPDATED;
        this.tryEnd();
    }

    @Override
    protected void rewindInternal() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private void tryEnd() throws Exception {
        assert (this.downstream() != null);
        if (this.state == State.UPDATING && this.waiting == 0) {
            this.waiting = 100;
            this.source().request(100);
        }
        if (this.state == State.UPDATED && this.requested > 0) {
            this.flushTuples(true);
            this.state = State.END;
            this.inLoop = true;
            try {
                --this.requested;
                this.downstream().push(this.context().rowHandler().factory(Long.TYPE).create(this.updatedRows));
            }
            finally {
                this.inLoop = false;
            }
        }
        if (this.state == State.END && this.requested > 0) {
            this.requested = 0;
            this.downstream().end();
        }
    }

    private Map<ModifyRow.Operation, Collection<BinaryRowEx>> getOperationsPerAction(List<ModifyRow> rows) {
        EnumMap<ModifyRow.Operation, Collection<BinaryRowEx>> store = new EnumMap<ModifyRow.Operation, Collection<BinaryRowEx>>(ModifyRow.Operation.class);
        for (ModifyRow tuple : rows) {
            store.computeIfAbsent(tuple.getOp(), k -> new ArrayList()).add(tuple.getRow());
        }
        return store;
    }

    private void flushTuples(boolean force) {
        if (CollectionUtils.nullOrEmpty(this.rows) || !force && this.rows.size() < 100) {
            return;
        }
        List<ModifyRow> rows = this.rows;
        this.rows = new ArrayList<ModifyRow>(100);
        Map<ModifyRow.Operation, Collection<BinaryRowEx>> operations = this.getOperationsPerAction(rows);
        block5: for (Map.Entry<ModifyRow.Operation, Collection<BinaryRowEx>> op : operations.entrySet()) {
            switch (op.getKey()) {
                case INSERT_ROW: {
                    Collection conflictKeys = (Collection)this.tableView.insertAll(op.getValue(), this.tx).join();
                    if (conflictKeys.isEmpty()) continue block5;
                    IgniteTypeFactory typeFactory = this.context().getTypeFactory();
                    RowHandler.RowFactory rowFactory = this.context().rowHandler().factory(this.context().getTypeFactory(), this.table.descriptor().insertRowType(typeFactory));
                    List<String> conflictKeys0 = conflictKeys.stream().map(binRow -> this.table.toRow(this.context(), (BinaryRow)binRow, rowFactory, null)).map(this.context().rowHandler()::toString).collect(Collectors.toList());
                    throw this.conflictKeysException(conflictKeys0);
                }
                case UPDATE_ROW: {
                    this.tableView.upsertAll(op.getValue(), this.tx).join();
                    continue block5;
                }
                case DELETE_ROW: {
                    this.tableView.deleteAll(op.getValue(), this.tx).join();
                    continue block5;
                }
            }
            throw new UnsupportedOperationException(op.getKey().name());
        }
        this.updatedRows += (long)rows.size();
    }

    private RuntimeException conflictKeysException(List<String> conflictKeys) {
        LOG.debug("Unable to update some keys because of conflict [op={}, keys={}]", new Object[]{this.modifyOp, conflictKeys});
        return new SqlException(ErrorGroups.Sql.DUPLICATE_KEYS_ERR, "PK unique constraint is violated");
    }

    private static enum State {
        UPDATING,
        UPDATED,
        END;

    }
}

