/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.internal.tx.Timestamp;
import org.jetbrains.annotations.Nullable;

public final class RowId
implements Serializable,
Comparable<RowId> {
    private final short partitionId;
    private final UUID uuid;

    public static RowId lowestRowId(int partitionId) {
        return new RowId(partitionId, Long.MIN_VALUE, Long.MIN_VALUE);
    }

    public RowId(int partitionId) {
        this(partitionId, Timestamp.nextVersion().toUuid());
    }

    public RowId(int partitionId, long mostSignificantBits, long leastSignificantBits) {
        this(partitionId, new UUID(mostSignificantBits, leastSignificantBits));
    }

    private RowId(int partitionId, UUID uuid) {
        this.partitionId = (short)partitionId;
        this.uuid = uuid;
    }

    public int partitionId() {
        return this.partitionId & 0xFFFF;
    }

    public long mostSignificantBits() {
        return this.uuid.getMostSignificantBits();
    }

    public long leastSignificantBits() {
        return this.uuid.getLeastSignificantBits();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowId rowId = (RowId)o;
        if (this.partitionId != rowId.partitionId) {
            return false;
        }
        return this.uuid.equals(rowId.uuid);
    }

    public int hashCode() {
        int result = this.partitionId;
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    @Override
    public int compareTo(RowId rowId) {
        int cmp = Short.compareUnsigned(this.partitionId, rowId.partitionId);
        if (cmp != 0) {
            return cmp;
        }
        return this.uuid.compareTo(rowId.uuid);
    }

    @Nullable
    public RowId increment() {
        long lsb = this.uuid.getLeastSignificantBits() + 1L;
        long msb = this.uuid.getMostSignificantBits();
        if (lsb == Long.MIN_VALUE && ++msb == Long.MIN_VALUE) {
            return null;
        }
        return new RowId(this.partitionId, msb, lsb);
    }

    public String toString() {
        return "RowId [partitionId=" + this.partitionId() + ", uuid=" + this.uuid + "]";
    }
}

