/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.internal.cli.sql.SqlQueryResult;
import org.apache.ignite.internal.cli.sql.table.Table;

public class SqlManager
implements AutoCloseable {
    private final Connection connection;

    public SqlManager(String jdbcUrl) throws SQLException {
        try {
            Class.forName("org.apache.ignite.jdbc.IgniteJdbcDriver");
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Jdbc driver not found.");
        }
        this.connection = DriverManager.getConnection(jdbcUrl);
    }

    public SqlQueryResult execute(String sql) throws SQLException {
        try (Statement statement = this.connection.createStatement();){
            if (statement.execute(sql)) {
                ResultSet resultSet = statement.getResultSet();
                SqlQueryResult sqlQueryResult = new SqlQueryResult(Table.fromResultSet(resultSet));
                return sqlQueryResult;
            }
            int updateCount = statement.getUpdateCount();
            SqlQueryResult sqlQueryResult = new SqlQueryResult((String)(updateCount >= 0 ? "Updated " + updateCount + " rows." : "OK!"));
            return sqlQueryResult;
        }
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    public DatabaseMetaData getMetadata() throws SQLException {
        return this.connection.getMetaData();
    }
}

