/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.cli.core.CallExecutionPipelineProvider;
import org.apache.ignite.internal.cli.core.repl.Repl;
import org.apache.ignite.internal.cli.core.repl.prompt.PromptProvider;
import org.apache.ignite.internal.cli.core.repl.terminal.TerminalCustomizer;
import org.jline.reader.Completer;
import picocli.CommandLine;

public class ReplBuilder {
    private PromptProvider promptProvider;
    private final Map<String, String> aliases = new HashMap<String, String>();
    private Class<?> commandClass;
    private CommandLine.IDefaultValueProvider defaultValueProvider;
    private TerminalCustomizer terminalCustomizer = terminal -> {};
    private Completer completer;
    private CallExecutionPipelineProvider provider;
    private String historyFileName;
    private boolean tailTipWidgetsEnabled;
    private Runnable onStart = () -> {};

    public Repl build() {
        return new Repl(this.promptProvider, this.commandClass, this.defaultValueProvider, this.aliases, this.terminalCustomizer, this.provider, this.completer, this.historyFileName, this.tailTipWidgetsEnabled, this.onStart);
    }

    public ReplBuilder withPromptProvider(PromptProvider promptProvider) {
        this.promptProvider = promptProvider;
        return this;
    }

    public ReplBuilder withCommandClass(Class<?> commandClass) {
        this.commandClass = commandClass;
        return this;
    }

    public ReplBuilder withDefaultValueProvider(CommandLine.IDefaultValueProvider defaultValueProvider) {
        this.defaultValueProvider = defaultValueProvider;
        return this;
    }

    public ReplBuilder withAliases(Map<String, String> aliases) {
        this.aliases.putAll(aliases);
        return this;
    }

    public ReplBuilder withTerminalCustomizer(TerminalCustomizer terminalCustomizer) {
        this.terminalCustomizer = terminalCustomizer;
        return this;
    }

    public ReplBuilder withCompleter(Completer completer) {
        this.completer = completer;
        return this;
    }

    public ReplBuilder withCallExecutionPipelineProvider(CallExecutionPipelineProvider provider) {
        this.provider = provider;
        return this;
    }

    public ReplBuilder withOnStart(Runnable onStart) {
        this.onStart = onStart;
        return this;
    }

    public ReplBuilder withHistoryFileName(String historyFileName) {
        this.historyFileName = historyFileName;
        return this;
    }

    public ReplBuilder withTailTipWidgets() {
        this.tailTipWidgetsEnabled = true;
        return this;
    }
}

