/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.node.version;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.rest.client.api.NodeManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.invoker.Configuration;

@Singleton
public class NodeVersionCall
implements Call<UrlCallInput, String> {
    @Override
    public CallOutput<String> execute(UrlCallInput input) {
        try {
            return DefaultCallOutput.success(this.getNodeVersion(input.getUrl()));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getUrl()));
        }
    }

    private String getNodeVersion(String url) throws ApiException {
        return new NodeManagementApi(Configuration.getDefaultApiClient().setBasePath(url)).nodeVersion();
    }
}

