/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.MemberAddArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class MembersAddArg {
    protected final List<MemberAddArg> newMembers;
    protected final boolean forceAsync;

    public MembersAddArg(List<MemberAddArg> newMembers, boolean forceAsync) {
        if (newMembers == null) {
            throw new IllegalArgumentException("Required value for 'newMembers' is null");
        }
        for (MemberAddArg x : newMembers) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'newMembers' is null");
        }
        this.newMembers = newMembers;
        this.forceAsync = forceAsync;
    }

    public MembersAddArg(List<MemberAddArg> newMembers) {
        this(newMembers, false);
    }

    public List<MemberAddArg> getNewMembers() {
        return this.newMembers;
    }

    public boolean getForceAsync() {
        return this.forceAsync;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.newMembers, this.forceAsync});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MembersAddArg other = (MembersAddArg)obj;
            return (this.newMembers == other.newMembers || this.newMembers.equals(other.newMembers)) && this.forceAsync == other.forceAsync;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MembersAddArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MembersAddArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("new_members");
            StoneSerializers.list(MemberAddArg.Serializer.INSTANCE).serialize(value.newMembers, g);
            g.writeFieldName("force_async");
            StoneSerializers.boolean_().serialize((Boolean)value.forceAsync, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public MembersAddArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_forceAsync;
            List<MemberAddArg> f_newMembers;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_newMembers = null;
                f_forceAsync = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("new_members".equals(field)) {
                        f_newMembers = StoneSerializers.list(MemberAddArg.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("force_async".equals(field)) {
                        f_forceAsync = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_newMembers == null) {
                    throw new JsonParseException(p, "Required field \"new_members\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MembersAddArg value = new MembersAddArg(f_newMembers, f_forceAsync);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

