/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.beam.sdk.transforms.SerializableComparator;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class KV<@UnknownKeyFor K, @UnknownKeyFor V>
implements Serializable {
    final K key;
    final V value;

    public static <K, V> @UnknownKeyFor @NonNull @Initialized KV<K, V> of(K key, V value) {
        return new KV<K, V>(key, value);
    }

    @Pure
    public K getKey() {
        return this.key;
    }

    @Pure
    public V getValue() {
        return this.value;
    }

    private KV(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KV)) {
            return false;
        }
        KV otherKv = (KV)other;
        return Objects.deepEquals(this.key, otherKv.key) && Objects.deepEquals(this.value, otherKv.value);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.key, this.value});
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.key).addValue(this.value).toString();
    }

    public static class OrderByValue<@UnknownKeyFor K, @UnknownKeyFor V extends @UnknownKeyFor @NonNull @Initialized Comparable<@UnknownKeyFor @NonNull @Initialized ? super V>>
    implements SerializableComparator<KV<K, V>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized KV<K, V> a, @UnknownKeyFor @NonNull @Initialized KV<K, V> b) {
            if (a.value == null) {
                return b.value == null ? 0 : -1;
            }
            if (b.value == null) {
                return 1;
            }
            return ((Comparable)a.value).compareTo(b.value);
        }
    }

    public static class OrderByKey<@UnknownKeyFor K extends @UnknownKeyFor @NonNull @Initialized Comparable<@UnknownKeyFor @NonNull @Initialized ? super K>, @UnknownKeyFor V>
    implements SerializableComparator<KV<K, V>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized KV<K, V> a, @UnknownKeyFor @NonNull @Initialized KV<K, V> b) {
            if (a.key == null) {
                return b.key == null ? 0 : -1;
            }
            if (b.key == null) {
                return 1;
            }
            return ((Comparable)a.key).compareTo(b.key);
        }
    }
}

