/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class PeriodicSequence
extends PTransform<PCollection<SequenceDefinition>, PCollection<Instant>> {
    private PeriodicSequence() {
    }

    public static @UnknownKeyFor @NonNull @Initialized PeriodicSequence create() {
        return new PeriodicSequence();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Instant> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SequenceDefinition> input) {
        return (PCollection)input.apply(ParDo.of(new PeriodicSequenceFn()));
    }

    private static class PeriodicSequenceFn
    extends DoFn<SequenceDefinition, Instant> {
        private PeriodicSequenceFn() {
        }

        @DoFn.GetInitialRestriction
        public @UnknownKeyFor @NonNull @Initialized OffsetRange getInitialRange(@DoFn.Element @UnknownKeyFor @NonNull @Initialized SequenceDefinition element) {
            return new OffsetRange(element.first.getMillis() - element.durationMilliSec, element.last.getMillis());
        }

        @DoFn.NewTracker
        public @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Long> newTracker(@DoFn.Restriction @UnknownKeyFor @NonNull @Initialized OffsetRange restriction) {
            return new OutputRangeTracker(restriction);
        }

        @DoFn.GetInitialWatermarkEstimatorState
        public @UnknownKeyFor @NonNull @Initialized Instant getInitialWatermarkState() {
            return BoundedWindow.TIMESTAMP_MIN_VALUE;
        }

        @DoFn.NewWatermarkEstimator
        public @UnknownKeyFor @NonNull @Initialized WatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> newWatermarkEstimator(@DoFn.WatermarkEstimatorState @UnknownKeyFor @NonNull @Initialized Instant state) {
            return new WatermarkEstimators.Manual(state);
        }

        @DoFn.TruncateRestriction
        public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.TruncateResult<@UnknownKeyFor @NonNull @Initialized OffsetRange> truncate() {
            return null;
        }

        @DoFn.ProcessElement
        public @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized SequenceDefinition srcElement, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> estimator, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Instant> out, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Long> restrictionTracker) {
            OffsetRange restriction = restrictionTracker.currentRestriction();
            Long interval = srcElement.durationMilliSec;
            Long nextOutput = restriction.getFrom() + interval;
            boolean claimSuccess = true;
            estimator.setWatermark(Instant.ofEpochMilli((long)nextOutput));
            while (claimSuccess && Instant.ofEpochMilli((long)nextOutput).isBeforeNow()) {
                claimSuccess = restrictionTracker.tryClaim(nextOutput);
                if (claimSuccess) {
                    Instant output = Instant.ofEpochMilli((long)nextOutput);
                    out.outputWithTimestamp(output, output);
                    estimator.setWatermark(output);
                    nextOutput = nextOutput + interval;
                }
                if (srcElement.catchUpToNow) continue;
            }
            DoFn.ProcessContinuation continuation = DoFn.ProcessContinuation.stop();
            if (claimSuccess) {
                Duration offset = srcElement.catchUpToNow ? new Duration((ReadableInstant)Instant.now(), (ReadableInstant)Instant.ofEpochMilli((long)nextOutput)) : new Duration((Object)interval);
                continuation = DoFn.ProcessContinuation.resume().withResumeDelay(offset);
            }
            return continuation;
        }
    }

    public static class OutputRangeTracker
    extends RestrictionTracker<OffsetRange, Long>
    implements RestrictionTracker.HasProgress {
        private @UnknownKeyFor @NonNull @Initialized OffsetRange range;
        private @Nullable @UnknownKeyFor @Initialized Long lastClaimedOffset = null;
        private @Nullable @UnknownKeyFor @Initialized Long lastAttemptedOffset = null;

        public OutputRangeTracker(@UnknownKeyFor @NonNull @Initialized OffsetRange range) {
            this.range = Preconditions.checkNotNull(range);
            this.lastAttemptedOffset = this.lastClaimedOffset = Long.valueOf(this.range.getFrom());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized OffsetRange currentRestriction() {
            return this.range;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized OffsetRange> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
            if (fractionOfRemainder != 0.0) {
                return null;
            }
            OffsetRange res = new OffsetRange(this.lastClaimedOffset, this.range.getTo());
            this.range = new OffsetRange(this.range.getFrom(), this.lastClaimedOffset);
            return SplitResult.of(this.range, res);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized Long i) {
            Preconditions.checkArgument(i > this.lastAttemptedOffset, "Trying to claim offset %s while last attempted was %s", (Object)i, (Object)this.lastAttemptedOffset);
            Preconditions.checkArgument(i >= this.range.getFrom(), "Trying to claim offset %s before start of the range %s", (Object)i, (Object)this.range);
            this.lastAttemptedOffset = i;
            if (i > this.range.getTo()) {
                return false;
            }
            this.lastClaimedOffset = i;
            return true;
        }

        @Override
        public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
            Preconditions.checkState(this.lastAttemptedOffset >= this.range.getTo() - 1L, "Last attempted offset was %s in range %s, claiming work in (%s, %s] was not attempted", (Object)this.lastAttemptedOffset, (Object)this.range, (Object)this.lastAttemptedOffset, (Object)this.range.getTo());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
            return RestrictionTracker.IsBounded.BOUNDED;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this).add("range", this.range).add("lastClaimedOffset", this.lastClaimedOffset).add("lastAttemptedOffset", this.lastAttemptedOffset).toString();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
            double workRemaining = Math.max(this.range.getTo() - this.lastAttemptedOffset, 0L);
            return RestrictionTracker.Progress.from((double)(this.range.getTo() - this.range.getFrom()) - workRemaining, workRemaining);
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class SequenceDefinition {
        public @UnknownKeyFor @NonNull @Initialized Instant first;
        public @UnknownKeyFor @NonNull @Initialized Instant last;
        public @UnknownKeyFor @NonNull @Initialized Long durationMilliSec;
        public @UnknownKeyFor @NonNull @Initialized boolean catchUpToNow;

        public SequenceDefinition() {
        }

        public SequenceDefinition(@UnknownKeyFor @NonNull @Initialized Instant first, @UnknownKeyFor @NonNull @Initialized Instant last, @UnknownKeyFor @NonNull @Initialized Duration duration) {
            this.first = first;
            this.last = last;
            this.durationMilliSec = duration.getMillis();
            this.catchUpToNow = true;
        }

        @Internal
        public SequenceDefinition(@UnknownKeyFor @NonNull @Initialized Instant first, @UnknownKeyFor @NonNull @Initialized Instant last, @UnknownKeyFor @NonNull @Initialized Duration duration, @UnknownKeyFor @NonNull @Initialized boolean catchUpToNow) {
            this.first = first;
            this.last = last;
            this.durationMilliSec = duration.getMillis();
            this.catchUpToNow = catchUpToNow;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SequenceDefinition src = (SequenceDefinition)obj;
            return src.first.equals((Object)this.first) && src.last.equals((Object)this.last) && src.durationMilliSec.equals(this.durationMilliSec);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            int result = Objects.hash(this.first, this.last, this.durationMilliSec);
            return result;
        }
    }
}

