/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FlatMapElements<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
extends PTransform<PCollection<? extends InputT>, PCollection<OutputT>> {
    private final transient @Nullable @UnknownKeyFor @Initialized TypeDescriptor<InputT> inputType;
    private final transient @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> outputType;
    private final @Nullable @UnknownKeyFor @Initialized Object fn;

    private FlatMapElements(@Nullable @UnknownKeyFor @Initialized Object fn, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<InputT> inputType, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType) {
        this.fn = fn;
        this.inputType = inputType;
        this.outputType = outputType;
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized FlatMapElements<InputT, OutputT> via(@UnknownKeyFor @NonNull @Initialized InferableFunction<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<OutputT>> fn) {
        TypeDescriptor outputType = TypeDescriptors.extractFromTypeParameters(fn.getOutputTypeDescriptor(), Iterable.class, new TypeDescriptors.TypeVariableExtractor<Iterable<OutputT>, OutputT>(){});
        TypeDescriptor<? super InputT> inputType = fn.getInputTypeDescriptor();
        return new FlatMapElements(fn, inputType, outputType);
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized FlatMapElements<InputT, OutputT> via(@UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<OutputT>> fn) {
        return FlatMapElements.via(fn);
    }

    public static <OutputT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized FlatMapElements<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> into(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType) {
        return new FlatMapElements(null, null, outputType);
    }

    public <NewInputT> @UnknownKeyFor @NonNull @Initialized FlatMapElements<NewInputT, OutputT> via(@UnknownKeyFor @NonNull @Initialized ProcessFunction<NewInputT, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<OutputT>> fn) {
        return new FlatMapElements<NewInputT, OutputT>(fn, TypeDescriptors.inputOf(fn), this.outputType);
    }

    public <NewInputT> @UnknownKeyFor @NonNull @Initialized FlatMapElements<NewInputT, OutputT> via(@UnknownKeyFor @NonNull @Initialized SerializableFunction<NewInputT, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<OutputT>> fn) {
        return this.via((ProcessFunction<NewInputT, ? extends Iterable<OutputT>>)fn);
    }

    public <NewInputT> @UnknownKeyFor @NonNull @Initialized FlatMapElements<NewInputT, OutputT> via(@UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<NewInputT, @UnknownKeyFor @NonNull @Initialized Iterable<OutputT>>> fn) {
        return new FlatMapElements<NewInputT, OutputT>(fn, TypeDescriptors.inputOf(fn.getClosure()), this.outputType);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends InputT> input) {
        Preconditions.checkArgument(this.fn != null, ".via() is required");
        if (this.fn instanceof Contextful) {
            return (PCollection)input.apply("FlatMap", ParDo.of(new FlatMapDoFn(){

                @DoFn.ProcessElement
                public void processElement(@UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Iterable res = (Iterable)((Contextful.Fn)((Contextful)FlatMapElements.this.fn).getClosure()).apply(c.element(), Contextful.Fn.Context.wrapProcessContext(c));
                    for (Object output : res) {
                        c.output(output);
                    }
                }
            }).withSideInputs(((Contextful)this.fn).getRequirements().getSideInputs()));
        }
        if (this.fn instanceof ProcessFunction) {
            return (PCollection)input.apply("FlatMap", ParDo.of(new FlatMapDoFn(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element InputT element, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<OutputT> receiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    Iterable res = (Iterable)((ProcessFunction)FlatMapElements.this.fn).apply(element);
                    for (Object output : res) {
                        receiver.output(output);
                    }
                }
            }));
        }
        throw new IllegalArgumentException(String.format("Unknown type of fn class %s", this.fn.getClass()));
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        Object fnForDisplayData = this.fn instanceof Contextful ? ((Contextful)this.fn).getClosure() : this.fn;
        builder.add(DisplayData.item("class", fnForDisplayData.getClass()));
        if (fnForDisplayData instanceof HasDisplayData) {
            builder.include("fn", (HasDisplayData)fnForDisplayData);
        }
    }

    public <NewFailureT> @UnknownKeyFor @NonNull @Initialized FlatMapWithFailures<InputT, OutputT, NewFailureT> exceptionsInto(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<NewFailureT> failureTypeDescriptor) {
        return new FlatMapWithFailures<InputT, OutputT, NewFailureT>(this.fn, this.inputType, this.outputType, null, failureTypeDescriptor);
    }

    public <FailureT> @UnknownKeyFor @NonNull @Initialized FlatMapWithFailures<InputT, OutputT, FailureT> exceptionsVia(@UnknownKeyFor @NonNull @Initialized InferableFunction< @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
        return new FlatMapWithFailures<InputT, OutputT, FailureT>(this.fn, this.inputType, this.outputType, exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    public static class FlatMapWithFailures<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor FailureT>
    extends PTransform<PCollection<InputT>, WithFailures.Result<PCollection<OutputT>, FailureT>> {
        private final transient @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> inputType;
        private final transient @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType;
        private final transient @Nullable @UnknownKeyFor @Initialized TypeDescriptor<FailureT> failureType;
        private final @Nullable @UnknownKeyFor @Initialized Object fn;
        private final @Nullable @UnknownKeyFor @Initialized ProcessFunction< @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler;

        FlatMapWithFailures(@UnknownKeyFor @NonNull @Initialized Object fn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> inputType, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType, @Nullable @UnknownKeyFor @Initialized ProcessFunction< @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<FailureT> failureType) {
            this.fn = fn;
            this.inputType = inputType;
            this.outputType = outputType;
            this.exceptionHandler = exceptionHandler;
            this.failureType = failureType;
        }

        public @UnknownKeyFor @NonNull @Initialized FlatMapWithFailures<InputT, OutputT, FailureT> exceptionsVia(@UnknownKeyFor @NonNull @Initialized ProcessFunction< @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
            return new FlatMapWithFailures<InputT, OutputT, FailureT>(this.fn, this.inputType, this.outputType, exceptionHandler, this.failureType);
        }

        @Override
        public  @UnknownKeyFor @NonNull @Initialized WithFailures.Result<@UnknownKeyFor @NonNull @Initialized PCollection<OutputT>, FailureT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            PCollectionTuple tuple;
            MapWithFailuresDoFn doFn;
            Preconditions.checkArgument(this.exceptionHandler != null, ".exceptionsVia() is required");
            if (this.fn instanceof Contextful) {
                doFn = new MapWithFailuresDoFn(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element InputT element, @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                        boolean exceptionWasThrown = false;
                        Iterable res = null;
                        try {
                            res = (Iterable)((Contextful.Fn)((Contextful)fn).getClosure()).apply(element, Contextful.Fn.Context.wrapProcessContext(c));
                        }
                        catch (Exception e) {
                            exceptionWasThrown = true;
                            WithFailures.ExceptionElement exceptionElement = WithFailures.ExceptionElement.of(element, e);
                            c.output(this.failureTag, exceptionHandler.apply(exceptionElement));
                        }
                        if (!exceptionWasThrown) {
                            for (Object output : res) {
                                c.output(output);
                            }
                        }
                    }
                };
                tuple = (PCollectionTuple)input.apply(FlatMapWithFailures.class.getSimpleName(), ParDo.of(doFn).withOutputTags(doFn.outputTag, TupleTagList.of(doFn.failureTag)).withSideInputs(((Contextful)this.fn).getRequirements().getSideInputs()));
            } else if (this.fn instanceof ProcessFunction) {
                doFn = new MapWithFailuresDoFn(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element InputT element, @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                        boolean exceptionWasThrown = false;
                        Iterable res = null;
                        try {
                            res = (Iterable)((ProcessFunction)fn).apply(element);
                        }
                        catch (Exception e) {
                            exceptionWasThrown = true;
                            WithFailures.ExceptionElement exceptionElement = WithFailures.ExceptionElement.of(element, e);
                            c.output(this.failureTag, exceptionHandler.apply(exceptionElement));
                        }
                        if (!exceptionWasThrown) {
                            for (Object output : res) {
                                c.output(output);
                            }
                        }
                    }
                };
                tuple = (PCollectionTuple)input.apply(FlatMapWithFailures.class.getSimpleName(), ParDo.of(doFn).withOutputTags(doFn.outputTag, TupleTagList.of(doFn.failureTag)));
            } else {
                throw new IllegalArgumentException(String.format("Unknown type of fn class %s", this.fn.getClass()));
            }
            return WithFailures.Result.of(tuple, doFn.outputTag, doFn.failureTag);
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            Object fnForDisplayData = this.fn instanceof Contextful ? ((Contextful)this.fn).getClosure() : this.fn;
            builder.add(DisplayData.item("class", fnForDisplayData.getClass()));
            if (fnForDisplayData instanceof HasDisplayData) {
                builder.include("fn", (HasDisplayData)fnForDisplayData);
            }
            builder.add(DisplayData.item("exceptionHandler.class", this.exceptionHandler.getClass()));
            if (this.exceptionHandler instanceof HasDisplayData) {
                builder.include("exceptionHandler", (HasDisplayData)((Object)this.exceptionHandler));
            }
        }

        private abstract class MapWithFailuresDoFn
        extends DoFn<InputT, OutputT> {
            final @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag = new TupleTag<OutputT>(){};
            final @UnknownKeyFor @NonNull @Initialized TupleTag<FailureT> failureTag = new FailureTag();

            private MapWithFailuresDoFn() {
            }

            @Override
            public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                builder.delegate(FlatMapWithFailures.this);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> getInputTypeDescriptor() {
                return FlatMapWithFailures.this.inputType;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> getOutputTypeDescriptor() {
                Preconditions.checkState(FlatMapWithFailures.this.outputType != null, "%s output type descriptor was null; this probably means that getOutputTypeDescriptor() was called after serialization/deserialization, but it is only available prior to serialization, for constructing a pipeline and inferring coders", (Object)FlatMapWithFailures.class.getSimpleName());
                return FlatMapWithFailures.this.outputType;
            }
        }

        private class FailureTag
        extends TupleTag<FailureT> {
            private FailureTag() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<FailureT> getTypeDescriptor() {
                return FlatMapWithFailures.this.failureType;
            }
        }
    }

    private abstract class FlatMapDoFn
    extends DoFn<InputT, OutputT> {
        private FlatMapDoFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> getInputTypeDescriptor() {
            return FlatMapElements.this.inputType;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> getOutputTypeDescriptor() {
            Preconditions.checkState(FlatMapElements.this.outputType != null, "%s output type descriptor was null; this probably means that getOutputTypeDescriptor() was called after serialization/deserialization, but it is only available prior to serialization, for constructing a pipeline and inferring coders", (Object)FlatMapElements.class.getSimpleName());
            return FlatMapElements.this.outputType;
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.delegate(FlatMapElements.this);
        }
    }
}

