/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ServiceLoader;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.utils.SchemaInformationProvider;
import org.apache.beam.sdk.schemas.utils.StaticSchemaInference;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.ByteBuddyUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Primitives;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertHelpers {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ConvertHelpers.class);

    public static <T> @UnknownKeyFor @NonNull @Initialized ConvertedSchemaInformation<T> getConvertedSchemaInformation(@UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> outputType, @UnknownKeyFor @NonNull @Initialized SchemaRegistry schemaRegistry) {
        ConvertedSchemaInformation<T> schemaInformation = null;
        for (SchemaInformationProvider provider : SchemaInformationProviders.INSTANCE) {
            schemaInformation = provider.getConvertedSchemaInformation(inputSchema, outputType);
            if (schemaInformation == null) continue;
            return schemaInformation;
        }
        if (schemaInformation == null) {
            Schema outputSchema = null;
            SchemaCoder<T> outputSchemaCoder = null;
            try {
                outputSchema = schemaRegistry.getSchema(outputType);
                outputSchemaCoder = SchemaCoder.of(outputSchema, outputType, schemaRegistry.getToRowFunction(outputType), schemaRegistry.getFromRowFunction(outputType));
            }
            catch (NoSuchSchemaException e) {
                LOG.debug("No schema found for type " + outputType, (Throwable)e);
            }
            Schema.FieldType unboxedType = null;
            if (outputSchema == null || !outputSchema.assignableToIgnoreNullable(inputSchema)) {
                Schema checkedSchema = inputSchema;
                if (inputSchema.getFieldCount() == 1) {
                    unboxedType = inputSchema.getField(0).getType();
                    checkedSchema = unboxedType.getTypeName().isCompositeType() && !outputSchema.assignableToIgnoreNullable(unboxedType.getRowSchema()) ? unboxedType.getRowSchema() : null;
                }
                if (checkedSchema != null) {
                    throw new RuntimeException("Cannot convert between types that don't have equivalent schemas. input schema: " + checkedSchema + " output schema: " + outputSchema);
                }
            }
            schemaInformation = new ConvertedSchemaInformation<T>(outputSchemaCoder, unboxedType);
        }
        return schemaInformation;
    }

    public static <OutputT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> getConvertPrimitive(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outputTypeDescriptor,  @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        Schema.FieldType expectedFieldType = StaticSchemaInference.fieldFromType(outputTypeDescriptor, JavaFieldSchema.JavaFieldTypeSupplier.INSTANCE);
        if (!expectedFieldType.equals(fieldType)) {
            throw new IllegalArgumentException("Element argument type " + outputTypeDescriptor + " does not work with expected schema field type " + fieldType);
        }
        Type expectedInputType = typeConversionsFactory.createTypeConversion(false).convert(outputTypeDescriptor);
        TypeDescriptor<?> outputType = outputTypeDescriptor;
        if (outputType.getRawType().isPrimitive()) {
            outputType = TypeDescriptor.of(Primitives.wrap(outputType.getRawType()));
        }
        TypeDescription.Generic genericType = TypeDescription.Generic.Builder.parameterizedType(SerializableFunction.class, (Type[])new Type[]{expectedInputType, outputType.getType()}).build();
        DynamicType.Builder builder = new ByteBuddy().subclass((TypeDefinition)genericType);
        try {
            return (SerializableFunction)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).method((ElementMatcher)ElementMatchers.named((String)"apply")).intercept((Implementation)new ConvertPrimitiveInstruction(outputType, typeConversionsFactory)).make().load(ReflectHelpers.findClassLoader(), ByteBuddyUtils.getClassLoadingStrategy(SerializableFunction.class)).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static class ConvertPrimitiveInstruction
    implements Implementation {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outputFieldType;
        private final  @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory;

        public ConvertPrimitiveInstruction(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outputFieldType,  @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
            this.outputFieldType = outputFieldType;
            this.typeConversionsFactory = typeConversionsFactory;
        }

        public @UnknownKeyFor @NonNull @Initialized InstrumentedType prepare(@UnknownKeyFor @NonNull @Initialized InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public @UnknownKeyFor @NonNull @Initialized ByteCodeAppender appender(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation readValue = MethodVariableAccess.REFERENCE.loadFrom(1);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{this.typeConversionsFactory.createSetterConversions(readValue).convert(this.outputFieldType), MethodReturn.REFERENCE});
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }

    public static class ConvertedSchemaInformation<@UnknownKeyFor T>
    implements Serializable {
        public final @Nullable @UnknownKeyFor @Initialized SchemaCoder<T> outputSchemaCoder;
        public final @Nullable @UnknownKeyFor @Initialized Schema.FieldType unboxedType;

        public ConvertedSchemaInformation(@Nullable @UnknownKeyFor @Initialized SchemaCoder<T> outputSchemaCoder, @Nullable @UnknownKeyFor @Initialized Schema.FieldType unboxedType) {
            assert (outputSchemaCoder != null || unboxedType != null);
            this.outputSchemaCoder = outputSchemaCoder;
            this.unboxedType = unboxedType;
        }
    }

    private static class SchemaInformationProviders {
        private static final @UnknownKeyFor @NonNull @Initialized ServiceLoader<@UnknownKeyFor @NonNull @Initialized SchemaInformationProvider> INSTANCE = ServiceLoader.load(SchemaInformationProvider.class);

        private SchemaInformationProviders() {
        }
    }
}

