/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public interface ValueProvider<@UnknownKeyFor T>
extends Serializable {
    public T get();

    public @UnknownKeyFor @NonNull @Initialized boolean isAccessible();

    @Internal
    public static class Deserializer
    extends JsonDeserializer<ValueProvider<?>>
    implements ContextualDeserializer {
        private final @UnknownKeyFor @NonNull @Initialized JavaType innerType;

        Deserializer() {
            this.innerType = null;
        }

        Deserializer(@UnknownKeyFor @NonNull @Initialized JavaType innerType) {
            this.innerType = innerType;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized JsonDeserializer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> createContextual(@UnknownKeyFor @NonNull @Initialized DeserializationContext ctxt, @UnknownKeyFor @NonNull @Initialized BeanProperty property) throws @UnknownKeyFor @NonNull @Initialized JsonMappingException {
            Preconditions.checkNotNull(ctxt, "Null DeserializationContext.");
            JavaType type = Preconditions.checkNotNull(ctxt.getContextualType(), "Invalid type: %s", ((Object)((Object)this)).getClass());
            JavaType[] params = type.findTypeParameters(ValueProvider.class);
            if (params.length != 1) {
                throw new RuntimeException("Unable to derive type for ValueProvider: " + type.toString());
            }
            JavaType param = params[0];
            return new Deserializer(param);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> deserialize(@UnknownKeyFor @NonNull @Initialized JsonParser jp, @UnknownKeyFor @NonNull @Initialized DeserializationContext ctxt) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized JsonProcessingException {
            JsonDeserializer dser = ctxt.findRootValueDeserializer(Preconditions.checkNotNull(this.innerType, "Invalid %s: innerType is null. Serialization error?", ((Object)((Object)this)).getClass()));
            Object o = dser.deserialize(jp, ctxt);
            return StaticValueProvider.of(o);
        }
    }

    @Internal
    public static class Serializer
    extends JsonSerializer<ValueProvider<?>> {
        public void serialize(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> value, @UnknownKeyFor @NonNull @Initialized JsonGenerator jgen, @UnknownKeyFor @NonNull @Initialized SerializerProvider provider) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value.isAccessible()) {
                jgen.writeObject(value.get());
            } else {
                jgen.writeNull();
            }
        }
    }

    public static class RuntimeValueProvider<@UnknownKeyFor T>
    implements ValueProvider<T>,
    Serializable {
        private static @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized PipelineOptions> optionsMap = new ConcurrentHashMap();
        private final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> klass;
        private final @UnknownKeyFor @NonNull @Initialized String methodName;
        private final @UnknownKeyFor @NonNull @Initialized String propertyName;
        private final @Nullable T defaultValue;
        private final @UnknownKeyFor @NonNull @Initialized Long optionsId;

        RuntimeValueProvider(@UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> klass, @UnknownKeyFor @NonNull @Initialized Long optionsId) {
            this.methodName = methodName;
            this.propertyName = propertyName;
            this.klass = klass;
            this.defaultValue = null;
            this.optionsId = optionsId;
        }

        RuntimeValueProvider(@UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions> klass, T defaultValue, @UnknownKeyFor @NonNull @Initialized Long optionsId) {
            this.methodName = methodName;
            this.propertyName = propertyName;
            this.klass = klass;
            this.defaultValue = defaultValue;
            this.optionsId = optionsId;
        }

        static void setRuntimeOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions runtimeOptions) {
            optionsMap.put(runtimeOptions.getOptionsId(), runtimeOptions);
        }

        @Override
        public T get() {
            PipelineOptions options = optionsMap.get(this.optionsId);
            if (options == null) {
                throw new IllegalStateException("Value only available at runtime, but accessed from a non-runtime context: " + this);
            }
            try {
                Method method = this.klass.getMethod(this.methodName, new Class[0]);
                PipelineOptions methodOptions = options.as(this.klass);
                InvocationHandler handler = Proxy.getInvocationHandler(methodOptions);
                ValueProvider result = (ValueProvider)handler.invoke(methodOptions, method, null);
                if (result instanceof StaticValueProvider) {
                    return result.get();
                }
                return this.defaultValue;
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to load runtime value.", e);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isAccessible() {
            return optionsMap.get(this.optionsId) != null;
        }

        public @UnknownKeyFor @NonNull @Initialized String propertyName() {
            return this.propertyName;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            if (this.isAccessible()) {
                return String.valueOf(this.get());
            }
            return MoreObjects.toStringHelper(this).add("propertyName", this.propertyName).add("default", this.defaultValue).toString();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other instanceof RuntimeValueProvider && Objects.equals(this.klass, ((RuntimeValueProvider)other).klass) && Objects.equals(this.methodName, ((RuntimeValueProvider)other).methodName) && Objects.equals(this.propertyName, ((RuntimeValueProvider)other).propertyName) && Objects.equals(this.defaultValue, ((RuntimeValueProvider)other).defaultValue) && Objects.equals(this.optionsId, ((RuntimeValueProvider)other).optionsId);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.klass, this.methodName, this.propertyName, this.defaultValue, this.optionsId);
        }
    }

    public static class NestedValueProvider<@UnknownKeyFor T, @UnknownKeyFor X>
    implements ValueProvider<T>,
    Serializable {
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<X> value;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<X, T> translator;
        private volatile transient T cachedValue;

        NestedValueProvider(@UnknownKeyFor @NonNull @Initialized ValueProvider<X> value, @UnknownKeyFor @NonNull @Initialized SerializableFunction<X, T> translator) {
            this.value = Preconditions.checkNotNull(value);
            this.translator = Preconditions.checkNotNull(translator);
        }

        public static <T, X> @UnknownKeyFor @NonNull @Initialized NestedValueProvider<T, X> of(@UnknownKeyFor @NonNull @Initialized ValueProvider<X> value, @UnknownKeyFor @NonNull @Initialized SerializableFunction<X, T> translator) {
            return new NestedValueProvider<T, X>(value, translator);
        }

        @Override
        public T get() {
            if (this.cachedValue == null) {
                this.cachedValue = this.translator.apply(this.value.get());
            }
            return this.cachedValue;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isAccessible() {
            return this.value.isAccessible();
        }

        public @UnknownKeyFor @NonNull @Initialized String propertyName() {
            if (this.value instanceof RuntimeValueProvider) {
                return ((RuntimeValueProvider)this.value).propertyName();
            }
            if (this.value instanceof NestedValueProvider) {
                return ((NestedValueProvider)this.value).propertyName();
            }
            throw new RuntimeException("Only a RuntimeValueProvider or a NestedValueProvider can supply a property name.");
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            if (this.isAccessible()) {
                return String.valueOf(this.get());
            }
            return MoreObjects.toStringHelper(this).add("value", this.value).add("translator", this.translator.getClass().getSimpleName()).toString();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other instanceof NestedValueProvider && Objects.equals(this.value, ((NestedValueProvider)other).value) && Objects.equals(this.translator, ((NestedValueProvider)other).translator);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.value, this.translator);
        }
    }

    public static class StaticValueProvider<@UnknownKeyFor T>
    implements ValueProvider<T>,
    Serializable {
        private final @Nullable T value;

        StaticValueProvider(@Nullable T value) {
            this.value = value;
        }

        public static <T> @UnknownKeyFor @NonNull @Initialized StaticValueProvider<T> of(T value) {
            return new StaticValueProvider<T>(value);
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isAccessible() {
            return true;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return String.valueOf(this.value);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other instanceof StaticValueProvider && Objects.equals(this.value, ((StaticValueProvider)other).value);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hashCode(this.value);
        }
    }
}

