/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableLikeCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ListCoder<@UnknownKeyFor T>
extends IterableLikeCoder<T, List<T>> {
    public static <T> @UnknownKeyFor @NonNull @Initialized ListCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        return new ListCoder<T>(elemCoder);
    }

    @Override
    protected final @UnknownKeyFor @NonNull @Initialized List<T> decodeToIterable(@UnknownKeyFor @NonNull @Initialized List<T> decodedElements) {
        return decodedElements;
    }

    protected ListCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        super(elemCoder, "List");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return this.getElemCoder().consistentWithEquals();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(@UnknownKeyFor @NonNull @Initialized List<T> values) {
        if (this.consistentWithEquals()) {
            return values;
        }
        ArrayList<Object> ret = new ArrayList<Object>(values.size());
        for (T value : values) {
            ret.add(this.getElemCoder().structuralValue(value));
        }
        return ret;
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        ListCoder.verifyDeterministic(this, "ListCoder.elemCoder must be deterministic", this.getElemCoder());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized List<T>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<List<T>>(this.getClass()){}.where(new TypeParameter<T>(){}, this.getElemCoder().getEncodedTypeDescriptor());
    }
}

