/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.beam.sdk.coders.BitConverters;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.BufferedElementCountingOutputStream;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.util.common.ElementByteSizeObservableIterable;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class IterableLikeCoder<@UnknownKeyFor T, @UnknownKeyFor IterableT extends @UnknownKeyFor @NonNull @Initialized Iterable<T>>
extends StructuredCoder<IterableT> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> elementCoder;
    private final @UnknownKeyFor @NonNull @Initialized String iterableName;

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getElemCoder() {
        return this.elementCoder;
    }

    protected abstract IterableT decodeToIterable(@UnknownKeyFor @NonNull @Initialized List<T> var1);

    protected IterableT decodeToIterable(@UnknownKeyFor @NonNull @Initialized List<T> decodedElements, @UnknownKeyFor @NonNull @Initialized long terminatorValue, @UnknownKeyFor @NonNull @Initialized InputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new IllegalStateException(String.format("%s does not support non zero terminator values. Received stream with terminator %s.", this.iterableName, terminatorValue));
    }

    protected IterableLikeCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> elementCoder, @UnknownKeyFor @NonNull @Initialized String iterableName) {
        Preconditions.checkArgument(elementCoder != null, "element Coder for IterableLikeCoder must not be null");
        Preconditions.checkArgument(iterableName != null, "iterable name for IterableLikeCoder must not be null");
        this.elementCoder = elementCoder;
        this.iterableName = iterableName;
    }

    @Override
    public void encode(IterableT iterable, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        if (iterable == null) {
            throw new CoderException("cannot encode a null " + this.iterableName);
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            BitConverters.writeBigEndianInt(collection.size(), outStream);
            for (Object elem : collection) {
                this.elementCoder.encode(elem, outStream);
            }
        } else {
            BitConverters.writeBigEndianInt(-1, outStream);
            BufferedElementCountingOutputStream countingOutputStream = new BufferedElementCountingOutputStream(outStream);
            for (Object elem : iterable) {
                countingOutputStream.markElementStart();
                this.elementCoder.encode(elem, countingOutputStream);
            }
            countingOutputStream.finish();
        }
    }

    @Override
    public IterableT decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        int size = BitConverters.readBigEndianInt(inStream);
        if (size >= 0) {
            ArrayList<T> elements = new ArrayList<T>(size);
            for (int i = 0; i < size; ++i) {
                elements.add(this.elementCoder.decode(inStream));
            }
            return this.decodeToIterable(elements);
        }
        ArrayList<T> elements = new ArrayList<T>();
        long count = VarInt.decodeLong(inStream);
        while (count > 0L) {
            elements.add(this.elementCoder.decode(inStream));
            if (--count != 0L) continue;
            count = VarInt.decodeLong(inStream);
        }
        if (count == 0L) {
            return this.decodeToIterable(elements);
        }
        return this.decodeToIterable(elements, count, inStream);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return Arrays.asList(this.elementCoder);
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "IterableLikeCoder can not guarantee deterministic ordering.");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(IterableT iterable) {
        return iterable instanceof ElementByteSizeObservableIterable;
    }

    @Override
    public void registerByteSizeObserver(IterableT iterable, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (iterable == null) {
            throw new CoderException("cannot encode a null Iterable");
        }
        if (iterable instanceof ElementByteSizeObservableIterable) {
            observer.setLazy();
            ElementByteSizeObservableIterable observableIterable = (ElementByteSizeObservableIterable)iterable;
            observableIterable.addObserver(new IteratorObserver(observer, iterable instanceof Collection));
        } else if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            observer.update(4L);
            for (Object elem : collection) {
                this.elementCoder.registerByteSizeObserver(elem, observer);
            }
        } else {
            observer.update(4L);
            long count = 0L;
            for (Object elem : iterable) {
                ++count;
                this.elementCoder.registerByteSizeObserver(elem, observer);
            }
            if (count > 0L) {
                observer.update(VarInt.getLength(count));
            }
            observer.update(1L);
        }
    }

    private static class IteratorObserver
    implements Observer {
        private final @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver outerObserver;
        private final @UnknownKeyFor @NonNull @Initialized boolean countable;

        public IteratorObserver(@UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver outerObserver, @UnknownKeyFor @NonNull @Initialized boolean countable) {
            this.outerObserver = outerObserver;
            this.countable = countable;
            if (countable) {
                outerObserver.update(4L);
            } else {
                outerObserver.update(5L);
            }
        }

        @Override
        public void update(@UnknownKeyFor @NonNull @Initialized Observable obs, @UnknownKeyFor @NonNull @Initialized Object obj) {
            if (!(obj instanceof Long)) {
                throw new AssertionError((Object)"unexpected parameter object");
            }
            if (this.countable) {
                this.outerObserver.update(obs, obj);
            } else {
                this.outerObserver.update(obs, 1L + (Long)obj);
            }
        }
    }
}

