/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.crypto.keys.Ed25519PublicKey;
import com.trilead.ssh2.signature.DSASHA1Verify;
import com.trilead.ssh2.signature.ECDSASHA2Verify;
import com.trilead.ssh2.signature.Ed25519Verify;
import com.trilead.ssh2.signature.RSASHA1Verify;
import com.trilead.ssh2.transport.KexManager;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class KnownHosts {
    public static final int HOSTKEY_IS_OK = 0;
    public static final int HOSTKEY_IS_NEW = 1;
    public static final int HOSTKEY_HAS_CHANGED = 2;
    protected final LinkedList<KnownHostsEntry> publicKeys = new LinkedList();
    private final String[] ALGOS_FOR_RSA = new String[]{"rsa-sha2-512", "rsa-sha2-256", "ssh-rsa"};
    private final String ALGO_FOR_DSS = "ssh-dss";
    private final String ALGO_FOR_EDDSA = "ssh-ed25519";

    public KnownHosts() {
    }

    public KnownHosts(char[] knownHostsData) throws IOException {
        this.initialize(knownHostsData);
    }

    public KnownHosts(File knownHosts) throws IOException {
        this.initialize(knownHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHostkey(String[] hostnames, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        if (hostnames == null) {
            throw new IllegalArgumentException("hostnames may not be null");
        }
        if ("ssh-rsa".equals(serverHostKeyAlgorithm) || "rsa-sha2-512".equals(serverHostKeyAlgorithm) || "rsa-sha2-256".equals(serverHostKeyAlgorithm)) {
            PublicKey rpk = RSASHA1Verify.get().decodePublicKey(serverHostKey);
            LinkedList<KnownHostsEntry> linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(hostnames, rpk));
            }
        } else if (serverHostKeyAlgorithm.equals("ssh-dss")) {
            PublicKey dpk = DSASHA1Verify.get().decodePublicKey(serverHostKey);
            LinkedList<KnownHostsEntry> linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(hostnames, dpk));
            }
        } else if (serverHostKeyAlgorithm.equals(ECDSASHA2Verify.ECDSASHA2NISTP256Verify.get().getKeyFormat())) {
            PublicKey epk = ECDSASHA2Verify.ECDSASHA2NISTP256Verify.get().decodePublicKey(serverHostKey);
            LinkedList<KnownHostsEntry> linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(hostnames, epk));
            }
        } else if (serverHostKeyAlgorithm.equals(ECDSASHA2Verify.ECDSASHA2NISTP384Verify.get().getKeyFormat())) {
            PublicKey epk = ECDSASHA2Verify.ECDSASHA2NISTP384Verify.get().decodePublicKey(serverHostKey);
            LinkedList<KnownHostsEntry> linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(hostnames, epk));
            }
        } else if (serverHostKeyAlgorithm.equals(ECDSASHA2Verify.ECDSASHA2NISTP521Verify.get().getKeyFormat())) {
            PublicKey epk = ECDSASHA2Verify.ECDSASHA2NISTP521Verify.get().decodePublicKey(serverHostKey);
            LinkedList<KnownHostsEntry> linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(hostnames, epk));
            }
        } else if ("ssh-ed25519".equals(serverHostKeyAlgorithm)) {
            PublicKey edpk = Ed25519Verify.get().decodePublicKey(serverHostKey);
            LinkedList<KnownHostsEntry> linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(hostnames, edpk));
            }
        } else {
            throw new IOException("Unknown host key type (" + serverHostKeyAlgorithm + ")");
        }
    }

    public void addHostkeys(char[] knownHostsData) throws IOException {
        this.initialize(knownHostsData);
    }

    public void addHostkeys(File knownHosts) throws IOException {
        this.initialize(knownHosts);
    }

    public static final String createHashedHostname(String hostname) {
        MessageDigest sha1;
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("VM doesn't support SHA1", e);
        }
        byte[] salt = new byte[sha1.getDigestLength()];
        new SecureRandom().nextBytes(salt);
        byte[] hash = KnownHosts.hmacSha1Hash(salt, hostname);
        String base64_salt = new String(Base64.encode(salt));
        String base64_hash = new String(Base64.encode(hash));
        return new String("|1|" + base64_salt + "|" + base64_hash);
    }

    private static final byte[] hmacSha1Hash(byte[] salt, String hostname) {
        Mac hmac;
        try {
            hmac = Mac.getInstance("HmacSHA1");
            if (salt.length != hmac.getMacLength()) {
                throw new IllegalArgumentException("Salt has wrong length (" + salt.length + ")");
            }
            hmac.init(new SecretKeySpec(salt, "HmacSHA1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to HMAC-SHA1", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unable to create SecretKey", e);
        }
        try {
            hmac.update(hostname.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            hmac.update(hostname.getBytes());
        }
        return hmac.doFinal();
    }

    private final boolean checkHashed(String entry, String hostname) {
        if (!entry.startsWith("|1|")) {
            return false;
        }
        int delim_idx = entry.indexOf(124, 3);
        if (delim_idx == -1) {
            return false;
        }
        String salt_base64 = entry.substring(3, delim_idx);
        String hash_base64 = entry.substring(delim_idx + 1);
        byte[] salt = null;
        byte[] hash = null;
        try {
            salt = Base64.decode(salt_base64.toCharArray());
            hash = Base64.decode(hash_base64.toCharArray());
        }
        catch (IOException e) {
            return false;
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            if (salt.length != sha1.getDigestLength()) {
                return false;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("VM does not support SHA1", e);
        }
        byte[] dig = KnownHosts.hmacSha1Hash(salt, hostname);
        for (int i = 0; i < dig.length; ++i) {
            if (dig[i] == hash[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkKey(String remoteHostname, PublicKey remoteKey) {
        int result = 1;
        LinkedList<KnownHostsEntry> linkedList = this.publicKeys;
        synchronized (linkedList) {
            for (KnownHostsEntry ke : this.publicKeys) {
                if (!this.hostnameMatches(ke.patterns, remoteHostname)) continue;
                boolean res = this.matchKeys(ke.key, remoteKey);
                if (res) {
                    return 0;
                }
                result = 2;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PublicKey> getAllKeys(String hostname) {
        ArrayList<PublicKey> keys = new ArrayList<PublicKey>();
        LinkedList<KnownHostsEntry> linkedList = this.publicKeys;
        synchronized (linkedList) {
            for (KnownHostsEntry ke : this.publicKeys) {
                if (!this.hostnameMatches(ke.patterns, hostname)) continue;
                keys.add(ke.key);
            }
        }
        return keys;
    }

    public String[] getPreferredServerHostkeyAlgorithmOrder(String hostname) {
        InetAddress[] ipAddresses;
        String[] algos = this.recommendHostkeyAlgorithms(hostname);
        if (algos != null) {
            return algos;
        }
        try {
            ipAddresses = InetAddress.getAllByName(hostname);
        }
        catch (UnknownHostException e) {
            return null;
        }
        for (InetAddress ipAddress : ipAddresses) {
            algos = this.recommendHostkeyAlgorithms(ipAddress.getHostAddress());
            if (algos == null) continue;
            return algos;
        }
        return null;
    }

    private final boolean hostnameMatches(String[] hostpatterns, String hostname) {
        boolean isMatch = false;
        boolean negate = false;
        hostname = hostname.toLowerCase(Locale.US);
        for (int k = 0; k < hostpatterns.length; ++k) {
            if (hostpatterns[k] == null) continue;
            String pattern = null;
            if (hostpatterns[k].length() > 0 && hostpatterns[k].charAt(0) == '!') {
                pattern = hostpatterns[k].substring(1);
                negate = true;
            } else {
                pattern = hostpatterns[k];
                negate = false;
            }
            if (isMatch && !negate) continue;
            if (pattern.charAt(0) == '|') {
                if (!this.checkHashed(pattern, hostname)) continue;
                if (negate) {
                    return false;
                }
                isMatch = true;
                continue;
            }
            if ((pattern = pattern.toLowerCase(Locale.US)).indexOf(63) != -1 || pattern.indexOf(42) != -1) {
                if (!this.pseudoRegex(pattern.toCharArray(), 0, hostname.toCharArray(), 0)) continue;
                if (negate) {
                    return false;
                }
                isMatch = true;
                continue;
            }
            if (pattern.compareTo(hostname) != 0) continue;
            if (negate) {
                return false;
            }
            isMatch = true;
        }
        return isMatch;
    }

    private void initialize(char[] knownHostsData) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new CharArrayReader(knownHostsData));
        while ((line = br.readLine()) != null) {
            String[] arr;
            if ((line = line.trim()).startsWith("#") || (arr = line.split(" ")).length < 3) continue;
            String[] hostnames = arr[0].split(",");
            byte[] msg = Base64.decode(arr[2].toCharArray());
            this.addHostkey(hostnames, arr[1], msg);
        }
    }

    private void initialize(File knownHosts) throws IOException {
        int len;
        char[] buff = new char[512];
        CharArrayWriter cw = new CharArrayWriter();
        knownHosts.createNewFile();
        FileReader fr = new FileReader(knownHosts);
        while ((len = fr.read(buff)) >= 0) {
            cw.write(buff, 0, len);
        }
        fr.close();
        this.initialize(cw.toCharArray());
    }

    private final boolean matchKeys(PublicKey key1, PublicKey key2) {
        return key1.equals(key2);
    }

    private final boolean pseudoRegex(char[] pattern, int i, char[] match, int j) {
        while (pattern.length != i) {
            if (pattern[i] == '*') {
                if (pattern.length == ++i) {
                    return true;
                }
                if (pattern[i] != '*' && pattern[i] != '?') {
                    do {
                        if (pattern[i] != match[j] || !this.pseudoRegex(pattern, i + 1, match, j + 1)) continue;
                        return true;
                    } while (match.length != ++j);
                    return false;
                }
                do {
                    if (!this.pseudoRegex(pattern, i, match, j)) continue;
                    return true;
                } while (match.length != ++j);
                return false;
            }
            if (match.length == j) {
                return false;
            }
            if (pattern[i] != '?' && pattern[i] != match[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return match.length == j;
    }

    private String[] recommendHostkeyAlgorithms(String hostname) {
        ArrayList<String> preferredAlgos = new ArrayList<String>();
        List<PublicKey> keys = this.getAllKeys(hostname);
        for (PublicKey key : keys) {
            if (key instanceof RSAPublicKey) {
                preferredAlgos.addAll(Arrays.asList(this.ALGOS_FOR_RSA));
                continue;
            }
            if (key instanceof DSAPublicKey) {
                preferredAlgos.add("ssh-dss");
                continue;
            }
            if (key instanceof Ed25519PublicKey) {
                preferredAlgos.add("ssh-ed25519");
                continue;
            }
            if (!(key instanceof ECPublicKey)) continue;
            preferredAlgos.add(ECDSASHA2Verify.getSshKeyType((ECPublicKey)key));
        }
        if (preferredAlgos.isEmpty()) {
            return null;
        }
        ArrayList<String> preferredAndOthers = new ArrayList<String>();
        ArrayList<String> notPreferred = new ArrayList<String>();
        for (String algo : KexManager.getDefaultServerHostkeyAlgorithmList()) {
            if (preferredAlgos.contains(algo)) {
                preferredAndOthers.add(algo);
                continue;
            }
            notPreferred.add(algo);
        }
        preferredAndOthers.addAll(notPreferred);
        return preferredAndOthers.toArray(new String[0]);
    }

    public int verifyHostkey(String hostname, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        PublicKey remoteKey = null;
        if ("ssh-rsa".equals(serverHostKeyAlgorithm) || "rsa-sha2-256".equals(serverHostKeyAlgorithm) || "rsa-sha2-512".equals(serverHostKeyAlgorithm)) {
            remoteKey = RSASHA1Verify.get().decodePublicKey(serverHostKey);
        } else if ("ssh-dss".equals(serverHostKeyAlgorithm)) {
            remoteKey = DSASHA1Verify.get().decodePublicKey(serverHostKey);
        } else if (ECDSASHA2Verify.ECDSASHA2NISTP256Verify.get().getKeyFormat().equals(serverHostKeyAlgorithm)) {
            remoteKey = ECDSASHA2Verify.ECDSASHA2NISTP256Verify.get().decodePublicKey(serverHostKey);
        } else if (ECDSASHA2Verify.ECDSASHA2NISTP384Verify.get().getKeyFormat().equals(serverHostKeyAlgorithm)) {
            remoteKey = ECDSASHA2Verify.ECDSASHA2NISTP384Verify.get().decodePublicKey(serverHostKey);
        } else if (ECDSASHA2Verify.ECDSASHA2NISTP521Verify.get().getKeyFormat().equals(serverHostKeyAlgorithm)) {
            remoteKey = ECDSASHA2Verify.ECDSASHA2NISTP521Verify.get().decodePublicKey(serverHostKey);
        } else if ("ssh-ed25519".equals(serverHostKeyAlgorithm)) {
            remoteKey = Ed25519Verify.get().decodePublicKey(serverHostKey);
        } else {
            throw new IllegalArgumentException("Unknown hostkey type " + serverHostKeyAlgorithm);
        }
        int result = this.checkKey(hostname, remoteKey);
        if (result == 0) {
            return result;
        }
        InetAddress[] ipAddresses = null;
        try {
            ipAddresses = InetAddress.getAllByName(hostname);
        }
        catch (UnknownHostException e) {
            return result;
        }
        for (InetAddress ipAddress : ipAddresses) {
            int newresult = this.checkKey(ipAddress.getHostAddress(), remoteKey);
            if (newresult == 0) {
                return newresult;
            }
            if (newresult != 2) continue;
            result = 2;
        }
        return result;
    }

    public static final void addHostkeyToFile(File knownHosts, String[] hostnames, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        if (hostnames == null || hostnames.length == 0) {
            throw new IllegalArgumentException("Need at least one hostname specification");
        }
        if (serverHostKeyAlgorithm == null || serverHostKey == null) {
            throw new IllegalArgumentException();
        }
        CharArrayWriter writer = new CharArrayWriter();
        for (int i = 0; i < hostnames.length; ++i) {
            if (i != 0) {
                writer.write(44);
            }
            writer.write(hostnames[i]);
        }
        writer.write(32);
        writer.write(serverHostKeyAlgorithm);
        writer.write(32);
        writer.write(Base64.encode(serverHostKey));
        writer.write("\n");
        char[] entry = writer.toCharArray();
        RandomAccessFile raf = new RandomAccessFile(knownHosts, "rw");
        long len = raf.length();
        if (len > 0L) {
            raf.seek(len - 1L);
            int last = raf.read();
            if (last != 10) {
                raf.write(10);
            }
        }
        try {
            raf.write(new String(entry).getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            raf.write(new String(entry).getBytes());
        }
        raf.close();
    }

    private static byte[] rawFingerPrint(String type, String keyType, byte[] hostkey) {
        MessageDigest dig;
        block6: {
            dig = null;
            try {
                if ("md5".equals(type)) {
                    dig = MessageDigest.getInstance("MD5");
                    break block6;
                }
                if ("sha1".equals(type)) {
                    dig = MessageDigest.getInstance("SHA1");
                    break block6;
                }
                throw new IllegalArgumentException("Unknown hash type " + type);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Unknown hash type " + type);
            }
        }
        if (!("ssh-ed25519".equals(keyType) || keyType.startsWith("ecdsa-sha2-") || "ssh-rsa".equals(keyType) || "ssh-dss".equals(keyType) || "rsa-sha2-256".equals(keyType) || "rsa-sha2-512".equals(keyType))) {
            throw new IllegalArgumentException("Unknown key type " + keyType);
        }
        if (hostkey == null) {
            throw new IllegalArgumentException("hostkey is null");
        }
        dig.update(hostkey);
        return dig.digest();
    }

    private static String rawToHexFingerprint(byte[] fingerprint) {
        char[] alpha = "0123456789abcdef".toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fingerprint.length; ++i) {
            if (i != 0) {
                sb.append(':');
            }
            int b = fingerprint[i] & 0xFF;
            sb.append(alpha[b >> 4]);
            sb.append(alpha[b & 0xF]);
        }
        return sb.toString();
    }

    private static final String rawToBubblebabbleFingerprint(byte[] raw) {
        char[] v = "aeiouy".toCharArray();
        char[] c = "bcdfghklmnprstvzx".toCharArray();
        StringBuilder sb = new StringBuilder();
        int seed = 1;
        int rounds = raw.length / 2 + 1;
        sb.append('x');
        for (int i = 0; i < rounds; ++i) {
            if (i + 1 < rounds || raw.length % 2 != 0) {
                sb.append(v[((raw[2 * i] >> 6 & 3) + seed) % 6]);
                sb.append(c[raw[2 * i] >> 2 & 0xF]);
                sb.append(v[((raw[2 * i] & 3) + seed / 6) % 6]);
                if (i + 1 >= rounds) continue;
                sb.append(c[raw[2 * i + 1] >> 4 & 0xF]);
                sb.append('-');
                sb.append(c[raw[2 * i + 1] & 0xF]);
                seed = (seed * 5 + ((raw[2 * i] & 0xFF) * 7 + (raw[2 * i + 1] & 0xFF))) % 36;
                continue;
            }
            sb.append(v[seed % 6]);
            sb.append('x');
            sb.append(v[seed / 6]);
        }
        sb.append('x');
        return sb.toString();
    }

    public static final String createHexFingerprint(String keytype, byte[] publickey) {
        byte[] raw = KnownHosts.rawFingerPrint("md5", keytype, publickey);
        return KnownHosts.rawToHexFingerprint(raw);
    }

    public static final String createBubblebabbleFingerprint(String keytype, byte[] publickey) {
        byte[] raw = KnownHosts.rawFingerPrint("sha1", keytype, publickey);
        return KnownHosts.rawToBubblebabbleFingerprint(raw);
    }

    protected class KnownHostsEntry {
        String[] patterns;
        PublicKey key;

        KnownHostsEntry(String[] patterns, PublicKey key) {
            this.patterns = patterns;
            this.key = key;
        }

        public String toString() {
            return "KnownHostsEntry{keyType=" + this.key.getAlgorithm() + "}";
        }
    }
}

