/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.SpannerException;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import java.util.Map;

class OpenTelemetrySpan
implements ISpan {
    private final Span openTelemetrySpan;

    OpenTelemetrySpan(Span openTelemetrySpan) {
        this.openTelemetrySpan = openTelemetrySpan;
    }

    Span getOpenTelemetrySpan() {
        return this.openTelemetrySpan;
    }

    @Override
    public void addAnnotation(String message, Map<String, Object> attributes) {
        AttributesBuilder otAttributesBuilder = Attributes.builder();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                otAttributesBuilder.put(key, (String)value);
                continue;
            }
            if (!(value instanceof Long)) continue;
            otAttributesBuilder.put(key, ((Long)value).longValue());
        }
        this.openTelemetrySpan.addEvent(message, otAttributesBuilder.build());
    }

    @Override
    public void addAnnotation(String message) {
        this.openTelemetrySpan.addEvent(message);
    }

    @Override
    public void addAnnotation(String message, String key, String value) {
        this.openTelemetrySpan.addEvent(message, Attributes.builder().put(key, value).build());
    }

    @Override
    public void addAnnotation(String message, String key, long value) {
        this.openTelemetrySpan.addEvent(message, Attributes.builder().put(key, value).build());
    }

    @Override
    public void addAnnotation(String message, Throwable e) {
        this.openTelemetrySpan.addEvent(message, this.createOpenTelemetryExceptionAnnotations(e));
    }

    @Override
    public void setStatus(Throwable e) {
        if (e instanceof SpannerException) {
            this.openTelemetrySpan.setStatus(StatusCode.ERROR, ((SpannerException)((Object)e)).getErrorCode().name());
        } else {
            this.openTelemetrySpan.setStatus(StatusCode.ERROR, ErrorCode.INTERNAL.name());
        }
        this.openTelemetrySpan.recordException(e);
    }

    @Override
    public void setStatus(ErrorCode errorCode) {
        this.openTelemetrySpan.setStatus(StatusCode.ERROR, errorCode.name());
    }

    @Override
    public void end() {
        this.openTelemetrySpan.end();
    }

    private Attributes createOpenTelemetryExceptionAnnotations(Throwable e) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        if (e instanceof SpannerException) {
            attributesBuilder.put("Status", ((SpannerException)((Object)e)).getErrorCode().toString());
        }
        return attributesBuilder.build();
    }
}

