/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionContextFutureImpl;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;

final class AsyncTransactionManagerImpl
implements TransactionContextFutureImpl.CommittableAsyncTransactionManager,
SessionImpl.SessionTransaction {
    private final SessionImpl session;
    private ISpan span;
    private final Options options;
    private TransactionRunnerImpl.TransactionContextImpl txn;
    private TransactionManager.TransactionState txnState;
    private final SettableApiFuture<CommitResponse> commitResponse = SettableApiFuture.create();

    AsyncTransactionManagerImpl(SessionImpl session, ISpan span, Options.TransactionOption ... options) {
        this.session = session;
        this.span = span;
        this.options = Options.fromTransactionOptions(options);
    }

    @Override
    public void setSpan(ISpan span) {
        this.span = span;
    }

    @Override
    public void close() {
        this.closeAsync();
    }

    @Override
    public ApiFuture<Void> closeAsync() {
        ApiFuture<Void> res = null;
        if (this.txnState == TransactionManager.TransactionState.STARTED) {
            res = this.rollbackAsync();
        }
        if (this.txn != null) {
            this.txn.close();
        }
        return (ApiFuture)MoreObjects.firstNonNull(res, (Object)ApiFutures.immediateFuture(null));
    }

    @Override
    public TransactionContextFutureImpl beginAsync() {
        Preconditions.checkState((this.txn == null ? 1 : 0) != 0, (Object)"begin can only be called once");
        return new TransactionContextFutureImpl(this, this.internalBeginAsync(true));
    }

    private ApiFuture<TransactionContext> internalBeginAsync(boolean firstAttempt) {
        this.txnState = TransactionManager.TransactionState.STARTED;
        this.txn = this.session.newTransaction(this.options);
        if (firstAttempt) {
            this.session.setActive(this);
        }
        final SettableApiFuture res = SettableApiFuture.create();
        ApiFuture<Void> fut = firstAttempt ? ApiFutures.immediateFuture(null) : this.txn.ensureTxnAsync();
        ApiFutures.addCallback(fut, (ApiFutureCallback)new ApiFutureCallback<Void>(){

            public void onFailure(Throwable t) {
                AsyncTransactionManagerImpl.this.onError(t);
                res.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(t)));
            }

            public void onSuccess(Void result) {
                res.set((Object)AsyncTransactionManagerImpl.this.txn);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return res;
    }

    @Override
    public void onError(Throwable t) {
        if (t instanceof AbortedException) {
            this.txnState = TransactionManager.TransactionState.ABORTED;
        }
    }

    @Override
    public ApiFuture<Timestamp> commitAsync() {
        Preconditions.checkState((this.txnState == TransactionManager.TransactionState.STARTED ? 1 : 0) != 0, (Object)("commit can only be invoked if the transaction is in progress. Current state: " + (Object)((Object)this.txnState)));
        if (this.txn.isAborted()) {
            this.txnState = TransactionManager.TransactionState.ABORTED;
            return ApiFutures.immediateFailedFuture((Throwable)((Object)SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, "Transaction already aborted")));
        }
        ApiFuture<CommitResponse> commitResponseFuture = this.txn.commitAsync();
        this.txnState = TransactionManager.TransactionState.COMMITTED;
        ApiFutures.addCallback(commitResponseFuture, (ApiFutureCallback)new ApiFutureCallback<CommitResponse>(){

            public void onFailure(Throwable t) {
                if (t instanceof AbortedException) {
                    AsyncTransactionManagerImpl.this.txnState = TransactionManager.TransactionState.ABORTED;
                } else {
                    AsyncTransactionManagerImpl.this.txnState = TransactionManager.TransactionState.COMMIT_FAILED;
                    AsyncTransactionManagerImpl.this.commitResponse.setException(t);
                }
            }

            public void onSuccess(CommitResponse result) {
                AsyncTransactionManagerImpl.this.commitResponse.set((Object)result);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ApiFutures.transform(commitResponseFuture, CommitResponse::getCommitTimestamp, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<Void> rollbackAsync() {
        Preconditions.checkState((this.txnState == TransactionManager.TransactionState.STARTED ? 1 : 0) != 0, (Object)"rollback can only be called if the transaction is in progress");
        try {
            ApiFuture apiFuture = ApiFutures.transformAsync(this.txn.rollbackAsync(), ignored -> ApiFutures.immediateFuture(null), (Executor)MoreExecutors.directExecutor());
            return apiFuture;
        }
        finally {
            this.txnState = TransactionManager.TransactionState.ROLLED_BACK;
        }
    }

    @Override
    public AsyncTransactionManager.TransactionContextFuture resetForRetryAsync() {
        return new TransactionContextFutureImpl(this, this.internalBeginAsync(false));
    }

    @Override
    public TransactionManager.TransactionState getState() {
        return this.txnState;
    }

    @Override
    public ApiFuture<CommitResponse> getCommitResponse() {
        return this.commitResponse;
    }

    @Override
    public void invalidate() {
        if (this.txnState == TransactionManager.TransactionState.STARTED || this.txnState == null) {
            this.txnState = TransactionManager.TransactionState.ROLLED_BACK;
        }
    }
}

