/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.www.BaseWorkflowServlet;
import org.apache.hop.www.WebResult;
import org.json.simple.parser.ParseException;

@HopServerServlet(id="registerPipeline", name="Add a pipeline to the server")
public class RegisterPipelineServlet
extends BaseWorkflowServlet {
    private static final long serialVersionUID = 468054102740138751L;
    public static final String CONTEXT_PATH = "/hop/registerPipeline";

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    @Override
    WebResult generateBody(HttpServletRequest request, HttpServletResponse response, boolean useXML, IVariables variables) throws IOException, HopException, HopException, ParseException {
        String xml = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        PipelineConfiguration pipelineConfiguration = PipelineConfiguration.fromXml(xml);
        IPipelineEngine<PipelineMeta> pipeline = this.createPipeline(pipelineConfiguration);
        String message = "Pipeline '" + pipeline.getPipelineMeta().getName() + "' was added to HopServer with id " + pipeline.getContainerId();
        return new WebResult("OK", message, pipeline.getContainerId());
    }
}

